/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.nodetable;

import java.nio.ByteBuffer;
import org.apache.jena.atlas.io.BlockUTF8;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapZero;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.riot.web.LangTag;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.store.nodetable.Nodec;
import org.slf4j.Logger;

public class NodecSSE
implements Nodec {
    private static final char MarkerChar = '_';
    private static final char[] invalidIRIChars = new char[]{'_', ' '};
    private static final PrefixMap pmap0 = PrefixMapZero.empty;
    private static final boolean onlySafeBNodeLabels = false;

    @Override
    public int maxSize(Node node) {
        return NodecSSE.maxLength(node);
    }

    @Override
    public int encode(Node node, ByteBuffer bb, PrefixMapping pmap) {
        String lang;
        String x;
        if (!node.isConcrete()) {
            FmtLog.warn((Logger)TDB.logInfo, (String)("Attempt to encode non-concrete node: " + node), (Object[])new Object[0]);
        }
        Object str = null;
        if (node.isURI() && (x = StrUtils.encodeHex((String)node.getURI(), (char)'_', (char[])invalidIRIChars)) != node.getURI()) {
            node = NodeFactory.createURI((String)x);
        }
        if (node.isLiteral() && NodeUtils.isLangString((Node)node) && !LangTag.check((String)(lang = node.getLiteralLanguage()))) {
            throw new TDBException("bad language tag: " + node);
        }
        if (node.isBlank()) {
            str = "_:" + node.getBlankNodeLabel();
        }
        if (node.isNodeTriple()) {
            str = NodeFmtLib.str((Node)node);
        }
        if (str == null) {
            str = NodeFmtLib.str((Node)node);
        }
        BlockUTF8.fromChars((CharSequence)str, (ByteBuffer)bb);
        bb.flip();
        return bb.limit();
    }

    @Override
    public Node decode(ByteBuffer bb, PrefixMapping pmap) {
        String str = BlockUTF8.toString((ByteBuffer)bb);
        if (str.startsWith("_:")) {
            str = str.substring(2);
            return NodeFactory.createBlankNode((String)str);
        }
        if (str.startsWith("<<")) {
            return SSE.parseNode((String)str);
        }
        if (str.startsWith("<")) {
            str = str.substring(1, str.length() - 1);
            str = StrUtils.unescapeString((String)str);
            str = StrUtils.decodeHex((String)str, (char)'_');
            return NodeFactory.createURI((String)str);
        }
        Tokenizer tokenizer = NodecSSE.createTokenizer(str);
        if (!tokenizer.hasNext()) {
            throw new TDBException("Failed to tokenize: " + str);
        }
        Token t = tokenizer.next();
        try {
            Node n = t.asNode();
            if (n == null) {
                throw new TDBException("Not a node: " + str);
            }
            return n;
        }
        catch (RiotException ex) {
            throw new TDBException("Bad string for node: " + str);
        }
    }

    private static Tokenizer createTokenizer(String string) {
        return TokenizerText.create().fromString(string).build();
    }

    private static int maxLength(Node node) {
        if (node.isBlank()) {
            return 2 + NodecSSE.maxLength(node.getBlankNodeLabel());
        }
        if (node.isURI()) {
            return 2 + NodecSSE.maxLength(node.getURI());
        }
        if (node.isLiteral()) {
            int len = 2 + NodecSSE.maxLength(node.getLiteralLexicalForm());
            if (NodeUtils.isLangString((Node)node)) {
                len = len + 3 + node.getLiteralLanguage().length();
            } else if (!NodeUtils.isSimpleString((Node)node)) {
                len = len + 4 + NodecSSE.maxLength(node.getLiteralDatatypeURI());
            }
            return len;
        }
        if (node.isVariable()) {
            return 1 + NodecSSE.maxLength(node.getName());
        }
        if (node.isNodeTriple()) {
            Triple t = node.getTriple();
            return 8 + NodecSSE.maxLength(t.getSubject()) + NodecSSE.maxLength(t.getPredicate()) + NodecSSE.maxLength(t.getObject());
        }
        throw new TDBException("Unrecognized node type: " + node);
    }

    private static int maxLength(String string) {
        return string.length() * 3;
    }
}

