/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.solver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.solver.Abortable;
import org.apache.jena.tdb.solver.BindingNodeId;
import org.apache.jena.tdb.solver.QueryIterTDB;
import org.apache.jena.tdb.solver.SolverLib;
import org.apache.jena.tdb.solver.SolverRX;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.GraphTDB;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.nodetable.NodeTable;
import org.apache.jena.tdb.store.nodetupletable.NodeTupleTable;

public class Solver {
    public static QueryIterator execute(GraphTDB graph, BasicPattern pattern, QueryIterator input, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        NodeTupleTable ntt = graph.getNodeTupleTable();
        return Solver.execute(ntt, graph.getGraphName(), pattern, input, filter, execCxt);
    }

    public static QueryIterator execute(DatasetGraphTDB ds, Node graphNode, BasicPattern pattern, QueryIterator input, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        NodeTupleTable ntt = ds.chooseNodeTupleTable(graphNode);
        return Solver.execute(ntt, graphNode, pattern, input, filter, execCxt);
    }

    private static QueryIterator execute(NodeTupleTable nodeTupleTable, Node graphNode, BasicPattern pattern, QueryIterator input, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        if (Quad.isUnionGraph((Node)graphNode)) {
            graphNode = Node.ANY;
        }
        if (Quad.isDefaultGraph((Node)graphNode)) {
            graphNode = null;
        }
        List triples = pattern.getList();
        boolean anyGraph = graphNode == null ? false : Node.ANY.equals((Object)graphNode);
        int tupleLen = nodeTupleTable.getTupleTable().getTupleLen();
        if (graphNode == null) {
            if (3 != tupleLen) {
                throw new TDBException("SolverLib: Null graph node but tuples are of length " + tupleLen);
            }
        } else if (4 != tupleLen) {
            throw new TDBException("SolverLib: Graph node specified but tuples are of length " + tupleLen);
        }
        NodeTable nodeTable = nodeTupleTable.getNodeTable();
        Iterator<BindingNodeId> chain = Iter.map((Iterator)input, SolverLib.convFromBinding(nodeTable));
        ArrayList<Abortable> killList = new ArrayList<Abortable>();
        for (Triple triple : triples) {
            Object patternTuple = null;
            patternTuple = graphNode == null ? TupleFactory.create3((Object)triple.getSubject(), (Object)triple.getPredicate(), (Object)triple.getObject()) : TupleFactory.create4((Object)graphNode, (Object)triple.getSubject(), (Object)triple.getPredicate(), (Object)triple.getObject());
            chain = Solver.matchQuadPattern(chain, graphNode, triple, nodeTupleTable, (Tuple<Node>)patternTuple, anyGraph, filter, execCxt);
            chain = SolverLib.makeAbortable(chain, killList);
        }
        Iterator<Binding> iterBinding = SolverLib.convertToNodes(chain, nodeTable);
        return new QueryIterTDB(iterBinding, killList, input, execCxt);
    }

    public static Iterator<BindingNodeId> matchQuadPattern(Iterator<BindingNodeId> chain, Node graphNode, Triple tPattern, NodeTupleTable nodeTupleTable, Tuple<Node> patternTuple, boolean anyGraph, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        return SolverRX.matchQuadPattern(chain, graphNode, tPattern, nodeTupleTable, patternTuple, anyGraph, filter, execCxt);
    }
}

