/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.LockMRSW;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.TransactionalLock;

public class TxnDataset2Graph
extends TransactionalLock {
    @Deprecated
    public static boolean TXN_DSG_GRAPH = true;
    private Graph primary;
    private Map<Object, TransactionHandler> handlers = new HashMap<Object, TransactionHandler>();
    private Object lock = new Object();
    private ThreadLocal<Set<Graph>> removedGraphs = ThreadLocal.withInitial(() -> null);

    public TxnDataset2Graph(Graph primaryGraph, Graph ... otherGraphs) {
        super((Lock)new LockMRSW());
        this.primary = primaryGraph;
        this.handlers = TxnDataset2Graph.buildHandlerSet(this.primary, Arrays.asList(otherGraphs));
    }

    private static Map<Object, TransactionHandler> buildHandlerSet(Graph primary, Collection<Graph> graphs) {
        HashMap<Object, TransactionHandler> handlers = new HashMap<Object, TransactionHandler>();
        TxnDataset2Graph.addHandler(handlers, primary);
        graphs.forEach(g -> TxnDataset2Graph.addHandler(handlers, g));
        return handlers;
    }

    private static void addHandler(Map<Object, TransactionHandler> handlers, Graph graph) {
        TransactionHandler th = graph.getTransactionHandler();
        if (!th.transactionsSupported()) {
            return;
        }
        Object key = TxnDataset2Graph.calcKey(graph);
        if (th.transactionsSupported()) {
            handlers.put(key, th);
        }
    }

    private static Object calcKey(Graph graph) {
        if (graph instanceof GraphView) {
            return ((GraphView)graph).getDataset();
        }
        if (graph instanceof InfGraph) {
            return TxnDataset2Graph.calcKey(((InfGraph)graph).getRawGraph());
        }
        return graph;
    }

    private static void removeHandler(Map<Object, TransactionHandler> handlers, Graph graph) {
        Object key = TxnDataset2Graph.calcKey(graph);
        handlers.remove(graph);
    }

    public void addGraph(Graph graph) {
        this.checkNotReadMode();
        if (graph == null) {
            return;
        }
        if (!this.handlers.containsKey(graph)) {
            TransactionHandler th;
            TxnDataset2Graph.addHandler(this.handlers, graph);
            if (super.isInTransaction() && (th = this.handlers.get(graph)) != null) {
                th.begin();
            }
        }
    }

    public void removeGraph(Graph graph) {
        this.checkNotReadMode();
        if (graph == null) {
            return;
        }
        if (!super.isInTransaction()) {
            TxnDataset2Graph.removeHandler(this.handlers, graph);
            return;
        }
        Set<Graph> toBeRemoved = this.removedGraphs.get();
        if (toBeRemoved == null) {
            toBeRemoved = new HashSet<Graph>();
            this.removedGraphs.set(toBeRemoved);
        }
        this.removedGraphs.get().add(graph);
    }

    public void setPrimaryGraph(Graph graph) {
        this.checkNotReadMode();
        if (graph == null) {
            return;
        }
        this.removeGraph(graph);
        this.addGraph(graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlers(Consumer<TransactionHandler> action) {
        Object object = this.lock;
        synchronized (object) {
            this.handlers.forEach((g, th) -> action.accept((TransactionHandler)th));
        }
    }

    private void checkNotReadMode() {
        if (!super.isInTransaction()) {
            return;
        }
        if (super.isTransactionMode(ReadWrite.READ)) {
            throw new JenaTransactionException("In READ mode in transaction");
        }
    }

    private void start() {
    }

    private void finish() {
        if (!super.isTransactionMode(ReadWrite.WRITE)) {
            return;
        }
        Set<Graph> toBeRemoved = this.removedGraphs.get();
        this.removedGraphs.remove();
        if (toBeRemoved == null) {
            return;
        }
        toBeRemoved.forEach(g -> TxnDataset2Graph.removeHandler(this.handlers, g));
    }

    @Override
    public void begin(TxnType type) {
        super.begin(type);
        this.start();
        this.handlers(h -> h.begin());
    }

    @Override
    public void commit() {
        this.handlers(h -> h.commit());
        this.finish();
        super.commit();
    }

    @Override
    public void abort() {
        this.handlers(h -> h.abort());
        this.finish();
        super.abort();
    }

    @Override
    public void end() {
        if (this.isTransactionMode(ReadWrite.WRITE)) {
            this.error("Write transaction - no commit or abort before end()");
        }
        if (super.isInTransaction()) {
            this.handlers(h -> h.commit());
            this.finish();
        }
        super.endOnce();
    }
}

