/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphReadOnly;
import org.apache.jena.sparql.core.DatasetGraphWrapperView;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphReadOnly;
import org.apache.jena.sparql.graph.GraphUnionRead;

public class DatasetGraphFilteredView
extends DatasetGraphReadOnly
implements DatasetGraphWrapperView {
    private final Predicate<Quad> quadFilter;
    private final Collection<Node> visibleGraphs;

    public DatasetGraphFilteredView(DatasetGraph dsg, Predicate<Quad> filter, Collection<Node> visibleGraphs) {
        super(dsg);
        this.quadFilter = filter;
        if (visibleGraphs.contains(Quad.defaultGraphIRI) || visibleGraphs.contains(Quad.defaultGraphNodeGenerated)) {
            Log.warn(DatasetGraphFilteredView.class, (String)"default graph Node in visibleGraphs collection - fix up applied");
            visibleGraphs = new HashSet<Node>(visibleGraphs);
            visibleGraphs.remove(Quad.defaultGraphIRI);
            visibleGraphs.remove(Quad.defaultGraphNodeGenerated);
        }
        this.visibleGraphs = visibleGraphs;
    }

    private boolean filter(Quad quad) {
        return this.quadFilter.test(quad);
    }

    private Iterator<Quad> filter(Iterator<Quad> iter) {
        return Iter.filter(iter, this::filter);
    }

    @Override
    public Graph getDefaultGraph() {
        GraphView g = GraphView.createDefaultGraph(this);
        return new GraphReadOnly(g);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        if (Quad.isUnionGraph(graphNode)) {
            return this.getUnionGraph();
        }
        GraphView g = GraphView.createNamedGraph(this, graphNode);
        return new GraphReadOnly(g);
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.visibleGraphs.iterator();
    }

    @Override
    public long size() {
        return this.visibleGraphs.size();
    }

    @Override
    public Graph getUnionGraph() {
        return new GraphUnionRead(this, this.visibleGraphs);
    }

    @Override
    public Iterator<Quad> find() {
        return this.filter(super.find());
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        return this.filter(super.find(g, s, p, o));
    }

    @Override
    public Iterator<Quad> find(Quad quad) {
        return this.filter(super.find(quad));
    }

    @Override
    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        return this.filter(super.findNG(g, s, p, o));
    }

    @Override
    public boolean contains(Node g, Node s, Node p, Node o) {
        return this.filter(super.find(g, s, p, o)).hasNext();
    }

    @Override
    public boolean contains(Quad quad) {
        return this.filter(super.find(quad)).hasNext();
    }

    @Override
    public boolean isEmpty() {
        return !this.find().hasNext();
    }
}

