/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.JenaConnectionException;
import org.apache.jena.rdfconnection.LibRDFConn;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemoteBuilder;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.web.HttpCaptureResponse;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.riot.web.HttpResponseHandler;
import org.apache.jena.riot.web.HttpResponseLib;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.jena.system.Txn;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class RDFConnectionRemote
implements RDFConnection {
    private static final String fusekiDftSrvQuery = "sparql";
    private static final String fusekiDftSrvUpdate = "update";
    private static final String fusekiDftSrvGSP = "data";
    private boolean isOpen = true;
    protected final String destination;
    protected final String svcQuery;
    protected final String svcUpdate;
    protected final String svcGraphStore;
    protected final Transactional txnLifecycle;
    protected final HttpClient httpClient;
    protected final HttpContext httpContext;
    protected final RDFFormat outputQuads;
    protected final RDFFormat outputTriples;
    protected final String acceptGraph;
    protected final String acceptDataset;
    protected final String acceptSparqlResults;
    protected final String acceptSelectResult;
    protected final String acceptAskResult;
    protected final boolean parseCheckQueries;
    protected final boolean parseCheckUpdates;

    public static RDFConnectionRemoteBuilder create() {
        return new RDFConnectionRemoteBuilder();
    }

    public static RDFConnectionRemoteBuilder create(RDFConnectionRemote base) {
        return new RDFConnectionRemoteBuilder(base);
    }

    @Deprecated
    public RDFConnectionRemote(HttpClient httpClient, String destination) {
        this(httpClient, Objects.requireNonNull(destination), fusekiDftSrvQuery, fusekiDftSrvUpdate, fusekiDftSrvGSP);
    }

    @Deprecated
    public RDFConnectionRemote(String destination) {
        this(Objects.requireNonNull(destination), fusekiDftSrvQuery, fusekiDftSrvUpdate, fusekiDftSrvGSP);
    }

    @Deprecated
    public RDFConnectionRemote(String sQuery, String sUpdate, String sGSP) {
        this(null, sQuery, sUpdate, sGSP);
    }

    @Deprecated
    public RDFConnectionRemote(String destination, String sQuery, String sUpdate, String sGSP) {
        this(null, destination, sQuery, sUpdate, sGSP);
    }

    @Deprecated
    public RDFConnectionRemote(HttpClient httpClient, String destination, String sQuery, String sUpdate, String sGSP) {
        this(null, httpClient, null, destination, sQuery, sUpdate, sGSP, RDFFormat.NQUADS, RDFFormat.NTRIPLES, "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.5", "application/trig,application/n-quads;q=0.9,text/x-nquads;q=0.8,application/x-trig;q=0.7,application/ld+json;q=0.5,*/*;q=0.5", null, QueryEngineHTTP.defaultSelectHeader(), QueryEngineHTTP.defaultAskHeader(), true, true);
        Log.warn((Object)this, (String)"** public RDFConnectionRemote constructors will be removed - use RDFConnectionRemoteBuilder **");
    }

    protected RDFConnectionRemote(Transactional txnLifecycle, HttpClient httpClient, HttpContext httpContext, String destination, String queryURL, String updateURL, String gspURL, RDFFormat outputQuads, RDFFormat outputTriples, String acceptDataset, String acceptGraph, String acceptSparqlResults, String acceptSelectResult, String acceptAskResult, boolean parseCheckQueries, boolean parseCheckUpdates) {
        this.httpClient = httpClient;
        this.httpContext = httpContext;
        this.destination = destination;
        this.svcQuery = queryURL;
        this.svcUpdate = updateURL;
        this.svcGraphStore = gspURL;
        if (txnLifecycle == null) {
            txnLifecycle = TransactionalLock.createMRPlusSW();
        }
        this.txnLifecycle = txnLifecycle;
        this.outputQuads = outputQuads;
        this.outputTriples = outputTriples;
        this.acceptDataset = acceptDataset;
        this.acceptGraph = acceptGraph;
        this.acceptSparqlResults = acceptSparqlResults;
        this.acceptSelectResult = acceptSelectResult;
        this.acceptAskResult = acceptAskResult;
        this.parseCheckQueries = parseCheckQueries;
        this.parseCheckUpdates = parseCheckUpdates;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public String getDestination() {
        return this.destination;
    }

    @Override
    public QueryExecution query(String queryString) {
        Objects.requireNonNull(queryString);
        return this.queryExec(null, queryString);
    }

    @Override
    public QueryExecution query(Query query) {
        Objects.requireNonNull(query);
        return this.queryExec(query, null);
    }

    private QueryExecution queryExec(Query query, String queryString) {
        this.checkQuery();
        if (query == null && queryString == null) {
            throw new InternalErrorException("Both query and query string are null");
        }
        if (query == null && this.parseCheckQueries) {
            QueryFactory.create((String)queryString);
        }
        String queryStringToSend = queryString != null ? queryString : query.toString();
        return RDFConnectionRemote.exec(() -> this.createQueryExecution(query, queryStringToSend));
    }

    private QueryExecution createQueryExecution(Query query, String queryStringToSend) {
        QueryEngineHTTP qExec;
        QueryEngineHTTP qEngine = qExec = new QueryEngineHTTP(this.svcQuery, queryStringToSend, this.httpClient, this.httpContext);
        if (query != null) {
            if (query.isSelectType() && this.acceptSelectResult != null) {
                qEngine.setAcceptHeader(this.acceptSelectResult);
            }
            if (query.isAskType() && this.acceptAskResult != null) {
                qEngine.setAcceptHeader(this.acceptAskResult);
            }
            if ((query.isConstructType() || query.isDescribeType()) && this.acceptGraph != null) {
                qEngine.setAcceptHeader(this.acceptGraph);
            }
            if (query.isConstructQuad()) {
                qEngine.setDatasetContentType(this.acceptDataset);
            }
        }
        if (qEngine.getAcceptHeader() == null && this.acceptSparqlResults != null) {
            qEngine.setAcceptHeader(this.acceptSparqlResults);
        }
        if (qEngine.getAcceptHeader() == null) {
            throw new JenaConnectionException("No Accept header");
        }
        return qExec;
    }

    @Override
    public void update(String updateString) {
        Objects.requireNonNull(updateString);
        this.updateExec(null, updateString);
    }

    @Override
    public void update(UpdateRequest update) {
        Objects.requireNonNull(update);
        this.updateExec(update, null);
    }

    private void updateExec(UpdateRequest update, String updateString) {
        this.checkUpdate();
        if (update == null && updateString == null) {
            throw new InternalErrorException("Both update request and update string are null");
        }
        if (update == null && this.parseCheckUpdates) {
            UpdateFactory.create((String)updateString);
        }
        String updateStringToSend = updateString != null ? updateString : update.toString();
        RDFConnectionRemote.exec(() -> HttpOp.execHttpPost((String)this.svcUpdate, (String)"application/sparql-update", (String)updateStringToSend, (HttpClient)this.httpClient, (HttpContext)this.httpContext));
    }

    @Override
    public Model fetch(String graphName) {
        this.checkGSP();
        String url = LibRDFConn.urlForGraph(this.svcGraphStore, graphName);
        Graph graph = this.fetch$(url);
        return ModelFactory.createModelForGraph((Graph)graph);
    }

    @Override
    public Model fetch() {
        this.checkGSP();
        return this.fetch(null);
    }

    private Graph fetch$(String url) {
        HttpCaptureResponse graph = HttpResponseLib.graphHandler();
        RDFConnectionRemote.exec(() -> HttpOp.execHttpGet((String)url, (String)this.acceptGraph, (HttpResponseHandler)graph, (HttpClient)this.httpClient, (HttpContext)this.httpContext));
        return (Graph)graph.get();
    }

    @Override
    public void load(String graph, String file) {
        this.checkGSP();
        this.upload(graph, file, false);
    }

    @Override
    public void load(String file) {
        this.checkGSP();
        this.upload(null, file, false);
    }

    @Override
    public void load(Model model) {
        this.doPutPost(model, null, false);
    }

    @Override
    public void load(String graphName, Model model) {
        this.doPutPost(model, graphName, false);
    }

    @Override
    public void put(String graph, String file) {
        this.checkGSP();
        this.upload(graph, file, true);
    }

    @Override
    public void put(String file) {
        this.checkGSP();
        this.upload(null, file, true);
    }

    @Override
    public void put(String graphName, Model model) {
        this.checkGSP();
        this.doPutPost(model, graphName, true);
    }

    @Override
    public void put(Model model) {
        this.checkGSP();
        this.doPutPost(model, null, true);
    }

    protected void upload(String graph, String file, boolean replace) {
        Lang lang = RDFLanguages.filenameToLang((String)file);
        if (RDFLanguages.isQuads((Lang)lang)) {
            throw new ARQException("Can't load quads into a graph");
        }
        if (!RDFLanguages.isTriples((Lang)lang)) {
            throw new ARQException("Not an RDF format: " + file + " (lang=" + lang + ")");
        }
        String url = LibRDFConn.urlForGraph(this.svcGraphStore, graph);
        this.doPutPost(url, file, lang, replace);
    }

    protected void doPutPost(String url, String file, Lang lang, boolean replace) {
        File f = new File(file);
        long length = f.length();
        InputStream source = IO.openFile((String)file);
        RDFConnectionRemote.exec(() -> {
            if (replace) {
                HttpOp.execHttpPut((String)url, (String)lang.getContentType().getContentType(), (InputStream)source, (long)length, (HttpClient)this.httpClient, (HttpContext)this.httpContext);
            } else {
                HttpOp.execHttpPost((String)url, (String)lang.getContentType().getContentType(), (InputStream)source, (long)length, null, null, (HttpClient)this.httpClient, (HttpContext)this.httpContext);
            }
        });
    }

    protected void doPutPost(Model model, String name, boolean replace) {
        String url = LibRDFConn.urlForGraph(this.svcGraphStore, name);
        RDFConnectionRemote.exec(() -> {
            Graph graph = model.getGraph();
            if (replace) {
                HttpOp.execHttpPut((String)url, (HttpEntity)this.graphToHttpEntity(graph), (HttpClient)this.httpClient, (HttpContext)this.httpContext);
            } else {
                HttpOp.execHttpPost((String)url, (HttpEntity)this.graphToHttpEntity(graph), null, null, (HttpClient)this.httpClient, (HttpContext)this.httpContext);
            }
        });
    }

    @Override
    public void delete(String graph) {
        this.checkGSP();
        String url = LibRDFConn.urlForGraph(this.svcGraphStore, graph);
        RDFConnectionRemote.exec(() -> HttpOp.execHttpDelete((String)url));
    }

    @Override
    public void delete() {
        this.checkGSP();
        this.delete(null);
    }

    @Override
    public Dataset fetchDataset() {
        if (this.destination == null) {
            throw new ARQException("Dataset operations not available - no dataset URL provided");
        }
        Dataset ds = DatasetFactory.createTxnMem();
        Txn.executeWrite((Transactional)ds, () -> {
            TypedInputStream s = RDFConnectionRemote.exec(() -> HttpOp.execHttpGet((String)this.destination, (String)this.acceptDataset, (HttpClient)this.httpClient, (HttpContext)this.httpContext));
            Lang lang = RDFLanguages.contentTypeToLang((String)s.getContentType());
            RDFDataMgr.read((Dataset)ds, (InputStream)s, (Lang)lang);
        });
        return ds;
    }

    @Override
    public void loadDataset(String file) {
        if (this.destination == null) {
            throw new ARQException("Dataset operations not available - no dataset URl provided");
        }
        this.doPutPostDataset(file, false);
    }

    @Override
    public void loadDataset(Dataset dataset) {
        if (this.destination == null) {
            throw new ARQException("Dataset operations not available - no dataset URl provided");
        }
        this.doPutPostDataset(dataset, false);
    }

    @Override
    public void putDataset(String file) {
        if (this.destination == null) {
            throw new ARQException("Dataset operations not available - no dataset URl provided");
        }
        this.doPutPostDataset(file, true);
    }

    @Override
    public void putDataset(Dataset dataset) {
        if (this.destination == null) {
            throw new ARQException("Dataset operations not available - no dataset URl provided");
        }
        this.doPutPostDataset(dataset, true);
    }

    protected void doPutPostDataset(String file, boolean replace) {
        Lang lang = RDFLanguages.filenameToLang((String)file);
        File f = new File(file);
        long length = f.length();
        RDFConnectionRemote.exec(() -> {
            InputStream source = IO.openFile((String)file);
            if (replace) {
                HttpOp.execHttpPut((String)this.destination, (String)lang.getContentType().getContentType(), (InputStream)source, (long)length, (HttpClient)this.httpClient, (HttpContext)this.httpContext);
            } else {
                HttpOp.execHttpPost((String)this.destination, (String)lang.getContentType().getContentType(), (InputStream)source, (long)length, null, null, (HttpClient)this.httpClient, (HttpContext)this.httpContext);
            }
        });
    }

    protected void doPutPostDataset(Dataset dataset, boolean replace) {
        RDFConnectionRemote.exec(() -> {
            DatasetGraph dsg = dataset.asDatasetGraph();
            if (replace) {
                HttpOp.execHttpPut((String)this.destination, (HttpEntity)this.datasetToHttpEntity(dsg), (HttpClient)this.httpClient, null);
            } else {
                HttpOp.execHttpPost((String)this.destination, (HttpEntity)this.datasetToHttpEntity(dsg), (HttpClient)this.httpClient, null);
            }
        });
    }

    protected void checkQuery() {
        this.checkOpen();
        if (this.svcQuery == null) {
            throw new ARQException("No query service defined for this RDFConnection");
        }
    }

    protected void checkUpdate() {
        this.checkOpen();
        if (this.svcUpdate == null) {
            throw new ARQException("No update service defined for this RDFConnection");
        }
    }

    protected void checkGSP() {
        this.checkOpen();
        if (this.svcGraphStore == null) {
            throw new ARQException("No SPARQL Graph Store service defined for this RDFConnection");
        }
    }

    protected void checkDataset() {
        this.checkOpen();
        if (this.destination == null) {
            throw new ARQException("Dataset operations not available - no dataset URL provided");
        }
    }

    protected void checkOpen() {
        if (!this.isOpen) {
            throw new ARQException("closed");
        }
    }

    @Override
    public void close() {
        this.isOpen = false;
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    protected HttpEntity graphToHttpEntity(Graph graph) {
        return this.graphToHttpEntity(graph, this.outputTriples);
    }

    protected HttpEntity graphToHttpEntity(Graph graph, RDFFormat syntax) {
        EntityTemplate entity = new EntityTemplate(out -> RDFDataMgr.write((OutputStream)out, (Graph)graph, (RDFFormat)syntax));
        String ct = syntax.getLang().getContentType().getContentType();
        entity.setContentType(ct);
        return entity;
    }

    protected HttpEntity datasetToHttpEntity(DatasetGraph dataset) {
        return this.datasetToHttpEntity(dataset, this.outputQuads);
    }

    protected HttpEntity datasetToHttpEntity(DatasetGraph dataset, RDFFormat syntax) {
        EntityTemplate entity = new EntityTemplate(out -> RDFDataMgr.write((OutputStream)out, (DatasetGraph)dataset, (RDFFormat)syntax));
        String ct = syntax.getLang().getContentType().getContentType();
        entity.setContentType(ct);
        return entity;
    }

    protected static void exec(Runnable action) {
        try {
            action.run();
        }
        catch (HttpException ex) {
            RDFConnectionRemote.handleHttpException(ex, false);
        }
    }

    protected static <X> X exec(Supplier<X> action) {
        try {
            return action.get();
        }
        catch (HttpException ex) {
            RDFConnectionRemote.handleHttpException(ex, true);
            return null;
        }
    }

    private static void handleHttpException(HttpException ex, boolean ignore404) {
        if (ex.getResponseCode() == 404 && ignore404) {
            return;
        }
        throw ex;
    }

    public void begin() {
        this.txnLifecycle.begin();
    }

    public void begin(TxnType txnType) {
        this.txnLifecycle.begin(txnType);
    }

    public void begin(ReadWrite mode) {
        this.txnLifecycle.begin(mode);
    }

    public boolean promote(Transactional.Promote promote) {
        return this.txnLifecycle.promote(promote);
    }

    public void commit() {
        this.txnLifecycle.commit();
    }

    public void abort() {
        this.txnLifecycle.abort();
    }

    public boolean isInTransaction() {
        return this.txnLifecycle.isInTransaction();
    }

    public void end() {
        this.txnLifecycle.end();
    }

    public ReadWrite transactionMode() {
        return this.txnLifecycle.transactionMode();
    }

    public TxnType transactionType() {
        return this.txnLifecycle.transactionType();
    }
}

