/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.transaction.TransactionalMonitor;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetChanges;
import org.apache.jena.sparql.core.DatasetGraphTriplesQuads;
import org.apache.jena.sparql.core.DatasetPrefixStorage;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadAction;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.lib.NodeLib;
import org.apache.jena.tdb2.setup.StoreParams;
import org.apache.jena.tdb2.store.DatasetGraphTxn;
import org.apache.jena.tdb2.store.DatasetPrefixesTDB;
import org.apache.jena.tdb2.store.GraphTDB;
import org.apache.jena.tdb2.store.IteratorTxnTracker;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.QuadTable;
import org.apache.jena.tdb2.store.StorageTDB;
import org.apache.jena.tdb2.store.TripleTable;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;

public final class DatasetGraphTDB
extends DatasetGraphTriplesQuads
implements DatasetGraphTxn,
Sync,
Closeable {
    private StorageTDB storage;
    private TransactionalSystem txnSystem;
    private final ReorderTransformation transform;
    private GraphTDB defaultGraphTDB;
    private final boolean checkForChange = false;
    private boolean closed = false;
    private static final boolean CHECK_TXN = true;
    private static final int sliceSize = 1000;
    public static boolean exceptionOnSync = true;
    private DatasetChanges monitor = null;
    private TransactionalMonitor txnMonitor = null;

    public DatasetGraphTDB(TransactionalSystem txnSystem, TripleTable tripleTable, QuadTable quadTable, DatasetPrefixesTDB prefixes, ReorderTransformation transform, Location location, StoreParams params) {
        this.reset(txnSystem, tripleTable, quadTable, prefixes, location, params);
        this.transform = transform;
        this.defaultGraphTDB = this.getDefaultGraphTDB();
    }

    public void reset(TransactionalSystem txnSystem, TripleTable tripleTable, QuadTable quadTable, DatasetPrefixesTDB prefixes, Location location, StoreParams params) {
        this.txnSystem = txnSystem;
        this.storage = new StorageTDB(tripleTable, quadTable, prefixes, location, params);
        this.defaultGraphTDB = this.getDefaultGraphTDB();
    }

    public QuadTable getQuadTable() {
        this.checkNotClosed();
        return this.storage.quadTable;
    }

    public TripleTable getTripleTable() {
        this.checkNotClosed();
        return this.storage.tripleTable;
    }

    public StorageTDB getStorage() {
        return this.storage;
    }

    public void setStorage(StorageTDB storage) {
        this.storage = storage;
    }

    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        this.checkNotClosed();
        return this.isolate(this.triples2quadsDftGraph(this.getTripleTable().find(s, p, o)));
    }

    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        this.checkNotClosed();
        return this.isolate(this.getQuadTable().find(g, s, p, o));
    }

    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        this.checkNotClosed();
        return this.isolate(this.getQuadTable().find(Node.ANY, s, p, o));
    }

    protected Iterator<Quad> triples2quadsDftGraph(Iterator<Triple> iter) {
        return this.isolate((Iterator)GraphUtils.triples2quads((Node)Quad.defaultGraphIRI, iter));
    }

    private <T> Iterator<T> isolate(Iterator<T> iterator) {
        if (this.txnSystem.isInTransaction()) {
            TxnId txnId = this.txnSystem.getThreadTransaction().getTxnId();
            return new IteratorTxnTracker<T>(iterator, this.txnSystem, txnId);
        }
        return Iter.iterator(iterator);
    }

    protected void addToDftGraph(Node s, Node p, Node o) {
        this.checkNotClosed();
        this.requireWriteTxn();
        this.notifyAdd(null, s, p, o);
        this.getTripleTable().add(s, p, o);
    }

    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        this.checkNotClosed();
        this.requireWriteTxn();
        this.notifyAdd(g, s, p, o);
        this.getQuadTable().add(g, s, p, o);
    }

    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        this.checkNotClosed();
        this.requireWriteTxn();
        this.notifyDelete(null, s, p, o);
        this.getTripleTable().delete(s, p, o);
    }

    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        this.checkNotClosed();
        this.requireWriteTxn();
        this.notifyDelete(g, s, p, o);
        this.getQuadTable().delete(g, s, p, o);
    }

    void requireWriteTxn() {
        Transaction txn = this.txnSystem.getThreadTransaction();
        if (txn == null) {
            throw new TransactionException("Not in a transaction");
        }
        if (txn.isWriteTxn()) {
            return;
        }
        boolean b = this.promote();
        if (!b) {
            throw new TransactionException("Can't write");
        }
    }

    private final void notifyAdd(Node g, Node s, Node p, Node o) {
        if (this.monitor == null) {
            return;
        }
        QuadAction action = QuadAction.ADD;
        this.monitor.change(action, g, s, p, o);
    }

    private final void notifyDelete(Node g, Node s, Node p, Node o) {
        if (this.monitor == null) {
            return;
        }
        QuadAction action = QuadAction.DELETE;
        this.monitor.change(action, g, s, p, o);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new TDBException("dataset closed");
        }
    }

    public void shutdown() {
        this.close();
        this.storage.tripleTable.close();
        this.storage.quadTable.close();
        this.storage.prefixes.close();
        this.txnSystem.getTxnMgr().shutdown();
    }

    public boolean containsGraph(Node graphNode) {
        this.checkNotClosed();
        if (Quad.isDefaultGraphExplicit((Node)graphNode) || Quad.isUnionGraph((Node)graphNode)) {
            return true;
        }
        return this._containsGraph(graphNode);
    }

    private boolean _containsGraph(Node graphNode) {
        Iterator<Tuple<NodeId>> x = this.storage.quadTable.getNodeTupleTable().findAsNodeIds(graphNode, null, null, null);
        if (x == null) {
            return false;
        }
        boolean result = x.hasNext();
        return result;
    }

    public void addGraph(Node graphName, Graph graph) {
        this.checkNotClosed();
        this.removeGraph(graphName);
        GraphUtil.addInto((Graph)this.getGraph(graphName), (Graph)graph);
    }

    public final void removeGraph(Node graphName) {
        this.checkNotClosed();
        this.deleteAny(graphName, Node.ANY, Node.ANY, Node.ANY);
    }

    public Graph getDefaultGraph() {
        this.checkNotClosed();
        return new GraphTDB(this, null);
    }

    public GraphTDB getDefaultGraphTDB() {
        this.checkNotClosed();
        return (GraphTDB)this.getDefaultGraph();
    }

    public Graph getUnionGraph() {
        return this.getGraph(Quad.unionGraph);
    }

    public Graph getGraph(Node graphNode) {
        this.checkNotClosed();
        return new GraphTDB(this, graphNode);
    }

    public GraphTDB getGraphTDB(Node graphNode) {
        this.checkNotClosed();
        return (GraphTDB)this.getGraph(graphNode);
    }

    public StoreParams getStoreParams() {
        this.checkNotClosed();
        return this.storage.storeParams;
    }

    public ReorderTransformation getReorderTransform() {
        this.checkNotClosed();
        return this.transform;
    }

    public DatasetPrefixStorage getPrefixes() {
        this.checkNotClosed();
        return this.storage.prefixes;
    }

    public Iterator<Node> listGraphNodes() {
        this.checkNotClosed();
        Iterator<Tuple<NodeId>> x = this.storage.quadTable.getNodeTupleTable().findAll();
        Iter z = Iter.iter(x).map(t -> (NodeId)t.get(0)).distinct();
        return NodeLib.nodes(this.storage.quadTable.getNodeTupleTable().getNodeTable(), (Iterator<NodeId>)z);
    }

    public long size() {
        this.checkNotClosed();
        return Iter.count(this.listGraphNodes());
    }

    public boolean isEmpty() {
        this.checkNotClosed();
        return this.getTripleTable().isEmpty() && this.getQuadTable().isEmpty();
    }

    public void clear() {
        this.checkNotClosed();
        this.getTripleTable().clearTriples();
        this.getQuadTable().clearQuads();
    }

    public NodeTupleTable chooseNodeTupleTable(Node graphNode) {
        this.checkNotClosed();
        if (graphNode == null || Quad.isDefaultGraph((Node)graphNode)) {
            return this.getTripleTable().getNodeTupleTable();
        }
        return this.getQuadTable().getNodeTupleTable();
    }

    public void deleteAny(Node g, Node s, Node p, Node o) {
        int len;
        this.checkNotClosed();
        if (this.monitor != null) {
            super.deleteAny(g, s, p, o);
            return;
        }
        NodeTupleTable t = this.chooseNodeTupleTable(g);
        Tuple[] array = new Tuple[1000];
        do {
            Iterator<Tuple<NodeId>> iter = null;
            iter = g == null ? t.findAsNodeIds(s, p, o) : t.findAsNodeIds(g, s, p, o);
            if (iter == null || !iter.hasNext()) {
                return;
            }
            for (len = 0; len < 1000 && iter.hasNext(); ++len) {
                array[len] = iter.next();
            }
            for (int i = 0; i < len; ++i) {
                t.getTupleTable().delete((Tuple<NodeId>)array[i]);
                array[i] = null;
            }
        } while (len >= 1000);
    }

    public Location getLocation() {
        return this.storage.location;
    }

    public void sync() {
        if (exceptionOnSync) {
            throw new JenaTransactionException("sync called");
        }
        this.checkNotClosed();
        this.syncStorage();
    }

    public void syncStorage() {
        this.storage.tripleTable.sync();
        this.storage.quadTable.sync();
        this.storage.prefixes.sync();
    }

    public void setDefaultGraph(Graph g) {
        throw new UnsupportedOperationException("Can't set default graph on a TDB-backed dataset");
    }

    public boolean isInTransaction() {
        return this.txnSystem.isInTransaction();
    }

    public ReadWrite transactionMode() {
        return this.txnSystem.transactionMode();
    }

    public TxnType transactionType() {
        return this.txnSystem.transactionType();
    }

    public void begin(TxnType txnType) {
        if (this.txnMonitor != null) {
            this.txnMonitor.startBegin(txnType);
        }
        this.txnSystem.begin(txnType);
        if (this.txnMonitor != null) {
            this.txnMonitor.finishBegin(txnType);
        }
    }

    public void begin(ReadWrite readWrite) {
        this.begin(TxnType.convert((ReadWrite)readWrite));
    }

    public boolean promote(Transactional.Promote txnType) {
        if (this.txnMonitor != null) {
            this.txnMonitor.startPromote(txnType);
        }
        try {
            boolean bl = this.txnSystem.promote(txnType);
            return bl;
        }
        finally {
            if (this.txnMonitor != null) {
                this.txnMonitor.finishPromote(txnType);
            }
        }
    }

    public void commit() {
        if (this.txnMonitor != null) {
            this.txnMonitor.startCommit();
        }
        this.txnSystem.commit();
        if (this.txnMonitor != null) {
            this.txnMonitor.finishCommit();
        }
    }

    public void abort() {
        if (this.txnMonitor != null) {
            this.txnMonitor.startAbort();
        }
        this.txnSystem.abort();
        if (this.txnMonitor != null) {
            this.txnMonitor.finishAbort();
        }
    }

    public void end() {
        if (this.txnMonitor != null) {
            this.txnMonitor.startEnd();
        }
        this.txnSystem.end();
        if (this.txnMonitor != null) {
            this.txnMonitor.finishEnd();
        }
    }

    public TransactionalSystem getTxnSystem() {
        return this.txnSystem;
    }

    public void setMonitor(DatasetChanges changes) {
        this.monitor = changes;
    }

    public void removeMonitor(DatasetChanges changes) {
        if (this.monitor != changes) {
            throw new InternalErrorException();
        }
        this.monitor = null;
    }

    public void setTransactionalMonitor(TransactionalMonitor changes) {
        this.txnMonitor = changes;
    }

    public void removeTransactionalMonitor(TransactionalMonitor changes) {
        if (this.txnMonitor != changes) {
            throw new InternalErrorException();
        }
        this.txnMonitor = null;
    }
}

