/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.base;

import java.util.Objects;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.tdb2.loader.base.LoaderOps;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.loader.base.ProgressMonitor;
import org.slf4j.Logger;

public class ProgressMonitorOutput
implements ProgressMonitor {
    private final MonitorOutput output;
    private final long tickPoint;
    private final int superTick;
    private final Timer timer;
    private final String label;
    private long counterBatch = 0L;
    private long counterTotal = 0L;
    private long lastTime = -1L;
    private long timeTotalMillis = -1L;

    public static ProgressMonitorOutput create(Logger log, String label, long tickPoint, int superTick) {
        Objects.requireNonNull(log);
        return ProgressMonitorOutput.create(LoaderOps.outputToLog(log), label, tickPoint, superTick);
    }

    public static ProgressMonitorOutput create(MonitorOutput output, String label, long tickPoint, int superTick) {
        Objects.requireNonNull(output);
        return new ProgressMonitorOutput(label, tickPoint, superTick, output);
    }

    public ProgressMonitorOutput(String label, long tickPoint, int superTick, MonitorOutput output) {
        this.output = output;
        this.label = label;
        this.tickPoint = tickPoint;
        this.superTick = superTick;
        this.timer = new Timer();
    }

    @Override
    public void startMessage() {
        this.startMessage(null);
    }

    @Override
    public void startMessage(String msg) {
        if (msg != null) {
            this.output.print(msg, new Object[0]);
        } else {
            this.output.print("Start: " + this.label, new Object[0]);
        }
    }

    @Override
    public void finishMessage(String msg) {
        long timePoint = this.timer.getTimeInterval();
        if (timePoint != 0L) {
            double time = (double)timePoint / 1000.0;
            long runAvgRate = this.counterTotal * 1000L / timePoint;
            this.print("%s: %,d %s %.2fs (Avg: %,d)", msg, this.counterTotal, this.label, time, runAvgRate);
        } else {
            this.print("%s: %,d %s (Avg: ----)", msg, this.counterTotal, this.label);
        }
    }

    @Override
    public void start() {
        this.timer.startTimer();
        this.lastTime = 0L;
    }

    @Override
    public void finish() {
        this.timeTotalMillis = this.timer.endTimer();
    }

    @Override
    public void tick() {
        ++this.counterBatch;
        ++this.counterTotal;
        if (ProgressMonitorOutput.tickPoint(this.counterTotal, this.tickPoint)) {
            long timePoint = this.timer.readTimer();
            long thisTime = timePoint - this.lastTime;
            if (thisTime != 0L && timePoint != 0L) {
                long batchAvgRate = this.counterBatch * 1000L / thisTime;
                long runAvgRate = this.counterTotal * 1000L / timePoint;
                this.print("Add: %,d %s (Batch: %,d / Avg: %,d)", this.counterTotal, this.label, batchAvgRate, runAvgRate);
            } else {
                this.print("Add: %,d %s (Batch: ---- / Avg: ----)", this.counterTotal, this.label);
            }
            this.lastTime = timePoint;
            if (ProgressMonitorOutput.tickPoint(this.counterTotal, (long)this.superTick * this.tickPoint)) {
                this.elapsed(timePoint);
            }
            this.counterBatch = 0L;
            this.lastTime = timePoint;
        }
    }

    @Override
    public long getTicks() {
        return this.counterTotal;
    }

    @Override
    public long getTime() {
        return this.timeTotalMillis;
    }

    protected void elapsed(long timerReading) {
        float elapsedSecs = (float)timerReading / 1000.0f;
        this.print("  Elapsed: %,.2f seconds [%s]", Float.valueOf(elapsedSecs), DateTimeUtils.nowAsString());
    }

    private void print(String fmt, Object ... args) {
        if (this.output != null) {
            this.output.print(fmt, args);
        }
    }

    static boolean tickPoint(long counter, long quantum) {
        return counter % quantum == 0L;
    }
}

