/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryExecutionBase;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.util.Context;

public class QueryExecutionFactory {
    protected QueryExecutionFactory() {
    }

    public static QueryExecution create(Query query) {
        QueryExecutionFactory.checkArg(query);
        return QueryExecutionFactory.make(query);
    }

    public static QueryExecution create(String queryStr) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr));
    }

    public static QueryExecution create(String queryStr, Syntax syntax) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax));
    }

    public static QueryExecution create(Query query, Dataset dataset) {
        return QueryExecutionFactory.make(query, dataset);
    }

    public static QueryExecution create(String queryStr, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr), dataset);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset);
    }

    public static QueryExecution create(Query query, Model model) {
        QueryExecutionFactory.checkArg(query);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.make(query, DatasetFactory.wrap(model));
    }

    public static QueryExecution create(String queryStr, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model);
    }

    public static QueryExecution create(String queryStr, Syntax lang, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, lang), model);
    }

    public static QueryExecution create(Query query, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query);
        QueryExecution qe = QueryExecutionFactory.make(query);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), initialBinding);
    }

    public static QueryExecution create(Query query, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(query, DatasetFactory.wrap(model), initialBinding);
    }

    public static QueryExecution create(String queryStr, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model, initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), model, initialBinding);
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query);
        QueryExecution qe = QueryExecutionFactory.make(query, dataset);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), dataset, initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset, initialBinding);
    }

    public static QueryExecution sparqlService(String service, String query) {
        return QueryExecutionFactory.sparqlService(service, query, (HttpClient)null);
    }

    public static QueryExecution sparqlService(String service, String query, HttpClient client) {
        return QueryExecutionFactory.sparqlService(service, query, client, null);
    }

    public static QueryExecution sparqlService(String service, String query, HttpClient client, HttpContext httpContext) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query);
        return QueryExecutionFactory.sparqlService(service, QueryFactory.create(query), client);
    }

    public static QueryExecution sparqlService(String service, String query, String defaultGraph) {
        return QueryExecutionFactory.sparqlService(service, query, defaultGraph, null);
    }

    public static QueryExecution sparqlService(String service, String query, String defaultGraph, HttpClient client) {
        return QueryExecutionFactory.sparqlService(service, query, defaultGraph, client, null);
    }

    public static QueryExecution sparqlService(String service, String query, String defaultGraph, HttpClient client, HttpContext httpContext) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query);
        return QueryExecutionFactory.sparqlService(service, QueryFactory.create(query), defaultGraph, client, httpContext);
    }

    public static QueryExecution sparqlService(String service, String query, List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        return QueryExecutionFactory.sparqlService(service, query, defaultGraphURIs, namedGraphURIs, null);
    }

    public static QueryExecution sparqlService(String service, String query, List<String> defaultGraphURIs, List<String> namedGraphURIs, HttpClient client) {
        return QueryExecutionFactory.sparqlService(service, query, defaultGraphURIs, namedGraphURIs, client, null);
    }

    public static QueryExecution sparqlService(String service, String query, List<String> defaultGraphURIs, List<String> namedGraphURIs, HttpClient client, HttpContext httpContext) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query);
        return QueryExecutionFactory.sparqlService(service, QueryFactory.create(query), defaultGraphURIs, namedGraphURIs, client, httpContext);
    }

    public static QueryExecution sparqlService(String service, Query query) {
        return QueryExecutionFactory.sparqlService(service, query, (HttpClient)null);
    }

    public static QueryExecution sparqlService(String service, Query query, HttpClient client) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query);
        return QueryExecutionFactory.createServiceRequest(service, query, client);
    }

    public static QueryExecution sparqlService(String service, Query query, HttpClient client, HttpContext httpContext) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query);
        return QueryExecutionFactory.createServiceRequest(service, query, client, httpContext);
    }

    public static QueryExecution sparqlService(String service, Query query, List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        return QueryExecutionFactory.sparqlService(service, query, defaultGraphURIs, namedGraphURIs, null, null);
    }

    public static QueryExecution sparqlService(String service, Query query, List<String> defaultGraphURIs, List<String> namedGraphURIs, HttpClient client) {
        return QueryExecutionFactory.sparqlService(service, query, defaultGraphURIs, namedGraphURIs, client, null);
    }

    public static QueryExecution sparqlService(String service, Query query, List<String> defaultGraphURIs, List<String> namedGraphURIs, HttpClient client, HttpContext httpContext) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query);
        QueryEngineHTTP qe = QueryExecutionFactory.createServiceRequest(service, query, client);
        if (defaultGraphURIs != null) {
            qe.setDefaultGraphURIs(defaultGraphURIs);
        }
        if (namedGraphURIs != null) {
            qe.setNamedGraphURIs(namedGraphURIs);
        }
        return qe;
    }

    public static QueryExecution sparqlService(String service, Query query, String defaultGraph) {
        return QueryExecutionFactory.sparqlService(service, query, defaultGraph, null);
    }

    public static QueryExecution sparqlService(String service, Query query, String defaultGraph, HttpClient client) {
        return QueryExecutionFactory.sparqlService(service, query, client, null);
    }

    public static QueryExecution sparqlService(String service, Query query, String defaultGraph, HttpClient client, HttpContext httpContext) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query);
        QueryEngineHTTP qe = QueryExecutionFactory.createServiceRequest(service, query, client, httpContext);
        qe.addDefaultGraph(defaultGraph);
        return qe;
    }

    public static QueryEngineHTTP createServiceRequest(String service, Query query) {
        return QueryExecutionFactory.createServiceRequest(service, query, null);
    }

    public static QueryEngineHTTP createServiceRequest(String service, Query query, HttpClient client) {
        QueryEngineHTTP qe = new QueryEngineHTTP(service, query, client);
        return qe;
    }

    public static QueryEngineHTTP createServiceRequest(String service, Query query, HttpClient client, HttpContext httpContext) {
        QueryEngineHTTP qe = new QueryEngineHTTP(service, query, client, httpContext);
        return qe;
    }

    public static Plan createPlan(Query query, DatasetGraph dataset, Binding input, Context context) {
        return QueryExecutionFactory.makePlan(query, dataset, input, context);
    }

    public static Plan createPlan(Query query, DatasetGraph dataset, Binding input) {
        return QueryExecutionFactory.makePlan(query, dataset, input, null);
    }

    private static Query toQuery(Element pattern) {
        Query query = QueryFactory.make();
        query.setQueryPattern(pattern);
        query.setQuerySelectType();
        query.setQueryResultStar(true);
        return query;
    }

    private static Plan makePlan(Query query, DatasetGraph dataset, Binding input, Context context) {
        QueryEngineFactory f;
        if (context == null) {
            context = new Context(ARQ.getContext());
        }
        if (input == null) {
            input = BindingRoot.create();
        }
        if ((f = QueryExecutionFactory.findFactory(query, dataset, context)) == null) {
            return null;
        }
        return f.create(query, dataset, input, context);
    }

    private static Query makeQuery(String queryStr) {
        return QueryFactory.create(queryStr);
    }

    private static Query makeQuery(String queryStr, Syntax syntax) {
        return QueryFactory.create(queryStr, syntax);
    }

    protected static QueryExecution make(Query query) {
        return QueryExecutionFactory.make(query, null);
    }

    protected static QueryExecution make(Query query, Dataset dataset) {
        return QueryExecutionFactory.make(query, dataset, null);
    }

    protected static QueryExecution make(Query query, Dataset dataset, Context context) {
        QueryEngineFactory f;
        query.setResultVars();
        if (context == null) {
            context = ARQ.getContext();
        }
        DatasetGraph dsg = null;
        if (dataset != null) {
            dsg = dataset.asDatasetGraph();
        }
        if ((f = QueryExecutionFactory.findFactory(query, dsg, context)) == null) {
            Log.warn(QueryExecutionFactory.class, (String)"Failed to find a QueryEngineFactory");
            return null;
        }
        return new QueryExecutionBase(query, dataset, context, f);
    }

    private static QueryEngineFactory findFactory(Query query, DatasetGraph dataset, Context context) {
        return QueryEngineRegistry.get().find(query, dataset, context);
    }

    private static void checkNotNull(Object obj, String msg) {
        if (obj == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void checkArg(Model model) {
        QueryExecutionFactory.checkNotNull(model, "Model is a null pointer");
    }

    private static void checkArg(String queryStr) {
        QueryExecutionFactory.checkNotNull(queryStr, "Query string is null");
    }

    private static void checkArg(Query query) {
        QueryExecutionFactory.checkNotNull(query, "Query is null");
    }
}

