/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.block;

import org.apache.jena.tdb.base.block.Block;
import org.apache.jena.tdb.base.block.BlockMgrBase;
import org.apache.jena.tdb.base.file.BlockAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlockMgrFileAccess
extends BlockMgrBase {
    private static Logger log = LoggerFactory.getLogger(BlockMgrFileAccess.class);
    private final BlockAccess file;
    private boolean closed = false;
    private boolean syncNeeded = false;

    BlockMgrFileAccess(BlockAccess blockAccess, int blockSize) {
        super(blockAccess.getLabel(), blockSize);
        this.file = blockAccess;
    }

    @Override
    protected Block allocate() {
        this.syncNeeded = true;
        return this.file.allocate(this.blockSize);
    }

    @Override
    public Block promote(Block block) {
        return block;
    }

    @Override
    public Block getReadIterator(long id) {
        return this.getBlock(id);
    }

    @Override
    public Block getRead(long id) {
        return this.getBlock(id);
    }

    @Override
    public Block getWrite(long id) {
        return this.getBlock(id);
    }

    private Block getBlock(long id) {
        Block block = this.file.read(id);
        return block;
    }

    @Override
    public void release(Block block) {
    }

    @Override
    public void write(Block block) {
        this.syncNeeded = true;
        this.file.write(block);
    }

    @Override
    public void overwrite(Block block) {
        this.syncNeeded = true;
        this.file.overwrite(block);
    }

    @Override
    public void free(Block block) {
    }

    @Override
    public boolean valid(int id) {
        return this.file.valid(id);
    }

    @Override
    public void sync() {
        if (this.syncNeeded) {
            this.file.sync();
        } else {
            this.syncNeeded = true;
        }
        this.syncNeeded = false;
    }

    @Override
    public void syncForce() {
        this.file.sync();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        this.file.close();
    }

    @Override
    public boolean isEmpty() {
        return this.file.isEmpty();
    }

    public String toString() {
        return String.format("BlockMgrFileAccess[%d bytes]:%s", this.blockSize, this.file);
    }

    @Override
    protected Logger log() {
        return log;
    }
}

