/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.store.DatasetGraphSwitchable;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.sys.CopyDSG;
import org.apache.jena.tdb2.sys.FilenameUtils;
import org.apache.jena.tdb2.sys.IOX;
import org.apache.jena.tdb2.sys.StoreConnection;
import org.apache.jena.tdb2.sys.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseOps {
    private static Logger LOG = LoggerFactory.getLogger(DatabaseOps.class);
    private static final String dbPrefix = "Data";
    private static final String SEP = "-";
    private static final String startCount = "0001";
    private static final String BACKUPS_DIR = "Backups";
    private static final String BACKUPS_FN = "backup";
    private static Object compactionLock = new Object();

    static DatasetGraph create(Location location) {
        return DatabaseOps.createSwitchable(location);
    }

    private static DatasetGraphSwitchable createSwitchable(Location location) {
        if (location.isMem()) {
            DatasetGraph dsg = StoreConnection.connectCreate(location).getDatasetGraph();
            return new DatasetGraphSwitchable(null, location, dsg);
        }
        if (!location.exists()) {
            throw new TDBException("No such location: " + location);
        }
        Path path = IOX.asPath(location);
        Path db = DatabaseOps.findLocation(path, dbPrefix);
        if (db == null) {
            db = path.resolve("Data-0001");
            IOX.createDirectory(db);
        }
        Location loc2 = IOX.asLocation(db);
        DatasetGraphTDB dsg = StoreConnection.connectCreate(loc2).getDatasetGraphTDB();
        DatasetGraphSwitchable appDSG = new DatasetGraphSwitchable(path, location, dsg);
        return appDSG;
    }

    public static String backup(DatasetGraphSwitchable container) {
        DatabaseOps.checkSupportsAdmin(container);
        Path dbPath = container.getContainerPath();
        Path backupDir = dbPath.resolve(BACKUPS_DIR);
        if (!Files.exists(backupDir, new LinkOption[0])) {
            IOX.createDirectory(backupDir);
        }
        DatasetGraphSwitchable dsg = container;
        Pair<OutputStream, Path> x = DatabaseOps.openUniqueFileForWriting(backupDir, BACKUPS_FN, "nq.gz");
        try (OutputStream out2 = (OutputStream)x.getLeft();
             GZIPOutputStream out1 = new GZIPOutputStream(out2, 8192);
             BufferedOutputStream out = new BufferedOutputStream(out1);){
            Txn.executeRead((Transactional)dsg, () -> DatabaseOps.lambda$backup$0(out, (DatasetGraph)dsg));
        }
        catch (IOException e) {
            throw IOX.exception(e);
        }
        return ((Path)x.getRight()).toString();
    }

    private static void checkSupportsAdmin(DatasetGraphSwitchable container) {
        if (!container.hasContainerPath()) {
            throw new TDBException("Dataset does not support admin operations");
        }
    }

    private static Pair<OutputStream, Path> openUniqueFileForWriting(Path dirPath, String basename, String ext) {
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Not a directory: " + dirPath);
        }
        if (basename.contains("/") || basename.contains("\\")) {
            throw new IllegalArgumentException("Basename must not contain a file path separator (\"/\" or \"\\\")");
        }
        String timestamp = DateTimeUtils.nowAsString((String)"yyyy-MM-dd_HHmmss");
        String filename = basename + "_" + timestamp;
        Path p = dirPath.resolve(filename + "." + ext);
        int x = 0;
        while (true) {
            try {
                OutputStream out = Files.newOutputStream(p, StandardOpenOption.CREATE_NEW);
                return Pair.create((Object)out, (Object)p);
            }
            catch (AccessDeniedException ex) {
                throw IOX.exception("Access denied", ex);
            }
            catch (FileAlreadyExistsException ex) {
            }
            catch (IOException ex) {
                throw IOX.exception(ex);
            }
            if (++x >= 5) {
                throw new RuntimeIOException("Can't create the unique name: number of attempts exceeded");
            }
            p = dirPath.resolve(filename + "_" + x + "." + ext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compact(DatasetGraphSwitchable container) {
        DatabaseOps.checkSupportsAdmin(container);
        Object object = compactionLock;
        synchronized (object) {
            Path base = container.getContainerPath();
            Path db1 = DatabaseOps.findLocation(base, dbPrefix);
            Location loc1 = IOX.asLocation(db1);
            Location loc1a = ((DatasetGraphTDB)container.get()).getLocation();
            if (loc1a.isMem()) {
                // empty if block
            }
            if (!loc1a.exists()) {
                throw new TDBException("No such location: " + loc1a);
            }
            if (!loc1.equals((Object)loc1a)) {
                throw new TDBException("Inconsistent (not latested?) : " + loc1a + " : " + loc1);
            }
            int v = IOX.extractIndex(db1.getFileName().toString(), dbPrefix, SEP);
            String next = FilenameUtils.filename(dbPrefix, SEP, v + 1);
            Path db2 = db1.getParent().resolve(next);
            IOX.createDirectory(db2);
            Location loc2 = IOX.asLocation(db2);
            LOG.debug(String.format("Compact %s -> %s\n", db1.getFileName(), db2.getFileName()));
            DatabaseOps.compact(container, loc1, loc2);
        }
    }

    private static void compact(DatasetGraphSwitchable container, Location loc1, Location loc2) {
        if (loc1.isMem() || loc2.isMem()) {
            throw new TDBException("Compact involves a memory location: " + loc1 + " : " + loc2);
        }
        StoreConnection srcConn = StoreConnection.connectExisting(loc1);
        if (srcConn == null) {
            throw new TDBException("No database at location : " + loc1);
        }
        DatasetGraphTDB dsgCurrent = (DatasetGraphTDB)container.get();
        if (!dsgCurrent.getLocation().equals((Object)loc1)) {
            throw new TDBException("Inconsistent locations for base : " + dsgCurrent.getLocation() + " , " + dsgCurrent.getLocation());
        }
        DatasetGraphTDB dsgBase = srcConn.getDatasetGraphTDB();
        if (dsgBase != dsgCurrent) {
            throw new TDBException("Inconsistent datasets : " + dsgCurrent.getLocation() + " , " + dsgBase.getLocation());
        }
        TransactionalSystem txnSystem = dsgBase.getTxnSystem();
        TransactionCoordinator txnMgr = dsgBase.getTxnSystem().getTxnMgr();
        txnMgr.tryBlockWriters();
        DatasetGraphTDB dsgCompact = StoreConnection.connectCreate(loc2).getDatasetGraphTDB();
        CopyDSG.copy(dsgBase, dsgCompact);
        TransactionCoordinator txnMgr2 = dsgCompact.getTxnSystem().getTxnMgr();
        txnMgr2.startExclusiveMode();
        txnMgr.startExclusiveMode();
        if (!container.change(dsgCurrent, dsgCompact)) {
            Log.warn(DatabaseOps.class, (String)"Inconistent: old datasetgraph not as expected");
            container.set(dsgCompact);
        }
        txnMgr2.finishExclusiveMode();
        StoreConnection.release(dsgBase.getLocation());
    }

    private static Path findLocation(Path directory, String namebase) {
        if (!Files.exists(directory, new LinkOption[0])) {
            return null;
        }
        List<Path> maybe = IOX.scanForDirByPattern(directory, namebase, SEP);
        return Util.getLastOrNull(maybe);
    }

    private static /* synthetic */ void lambda$backup$0(OutputStream out, DatasetGraph dsg) {
        RDFDataMgr.write((OutputStream)out, (DatasetGraph)dsg, (Lang)Lang.NQUADS);
    }
}

