/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store;

import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.impl.TransactionHandlerBase;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.GraphTDB;

public class GraphNonTxnTDB
extends GraphTDB
implements Closeable,
Sync {
    private final DatasetGraphTDB dataset;

    public GraphNonTxnTDB(DatasetGraphTDB dataset, Node graphName) {
        super((DatasetGraph)dataset, graphName);
        this.dataset = dataset;
    }

    @Override
    public DatasetGraphTDB getDatasetGraphTDB() {
        return this.dataset;
    }

    @Override
    protected DatasetGraphTDB getBaseDatasetGraphTDB() {
        return this.dataset;
    }

    public TransactionHandler getTransactionHandler() {
        return new TransactionHandlerTDB(this);
    }

    private static class TransactionHandlerTDB
    extends TransactionHandlerBase {
        private final Graph graph;

        public TransactionHandlerTDB(GraphTDB graph) {
            this.graph = graph;
        }

        public void abort() {
            throw new UnsupportedOperationException("TDB: 'abort' of a transaction not supported");
        }

        public void begin() {
        }

        public void commit() {
            TDB.sync(this.graph);
        }

        public boolean transactionsSupported() {
            return false;
        }
    }
}

