/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.binding;

import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.Binding0;
import org.apache.jena.sparql.engine.binding.Binding1;
import org.apache.jena.sparql.engine.binding.BindingBase;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.binding.BindingRoot;

public class BindingFactory {
    public static final Binding noParent = null;

    public static Binding binding() {
        return BindingFactory.binding(noParent);
    }

    public static Binding binding(Binding parent) {
        return new Binding0(parent);
    }

    public static Binding binding(Var var, Node node) {
        return BindingFactory.binding(noParent, var, node);
    }

    public static Binding binding(Binding parent, Var var, Node node) {
        BindingBase.checkPair(var, node);
        if (Var.isAnonVar(var)) {
            return new Binding0(parent);
        }
        return new Binding1(parent, var, node);
    }

    public static BindingMap create() {
        return BindingFactory.create(noParent);
    }

    public static BindingMap create(Binding parent) {
        return new BindingHashMap(parent);
    }

    public static Binding root() {
        return BindingRoot.create();
    }

    public static Binding materialize(Binding b) {
        Iterator<Var> vIter = b.vars();
        BindingMap b2 = BindingFactory.create();
        while (vIter.hasNext()) {
            Var v = vIter.next();
            b2.add(v, b.get(v));
        }
        return b2;
    }
}

