/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.lib.Alarm;
import org.apache.jena.atlas.lib.AlarmClock;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.describe.DescribeHandler;
import org.apache.jena.sparql.core.describe.DescribeHandlerRegistry;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.ResultSetCheckCondition;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.engine.binding.BindingUtils;
import org.apache.jena.sparql.engine.iterator.QueryIteratorWrapper;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.DatasetUtils;
import org.apache.jena.sparql.util.ModelUtils;

public class QueryExecutionBase
implements QueryExecution {
    private Query query;
    private Dataset dataset;
    private QueryEngineFactory qeFactory;
    private QueryIterator queryIterator = null;
    private Plan plan = null;
    private Context context;
    private QuerySolution initialBinding = null;
    private volatile boolean isCancelled = false;
    private boolean closed;
    private volatile TimeoutCallback expectedCallback = null;
    private Alarm timeout1Alarm = null;
    private Alarm timeout2Alarm = null;
    private final Object lockTimeout = new Object();
    private static final long TIMEOUT_UNSET = -1L;
    private static final long TIMEOUT_INF = -2L;
    private long timeout1 = -1L;
    private long timeout2 = -1L;
    private final AlarmClock alarmClock = AlarmClock.get();

    public QueryExecutionBase(Query query, Dataset dataset, Context context, QueryEngineFactory qeFactory) {
        this.query = query;
        this.dataset = dataset;
        this.context = context;
        this.qeFactory = qeFactory;
        this.init();
    }

    private void init() {
        DatasetGraph dsg = this.dataset == null ? null : this.dataset.asDatasetGraph();
        this.context = Context.setupContextExec(this.context, dsg);
        if (this.query != null) {
            this.context.put(ARQConstants.sysCurrentQuery, this.query);
        }
        this.setAnyTimeouts();
    }

    private void setAnyTimeouts() {
        block8: {
            if (this.context.isDefined(ARQ.queryTimeout)) {
                Object obj = this.context.get(ARQ.queryTimeout);
                if (obj instanceof Number) {
                    long x = ((Number)obj).longValue();
                    this.setTimeout(x);
                } else if (obj instanceof String) {
                    try {
                        String str2 = obj.toString();
                        if (str2.contains(",")) {
                            String[] a = str2.split(",");
                            long x1 = Long.parseLong(a[0]);
                            long x2 = Long.parseLong(a[1]);
                            this.setTimeout(x1, x2);
                            break block8;
                        }
                        long x = Long.parseLong(str2);
                        this.setTimeout(x);
                    }
                    catch (RuntimeException ex) {
                        Log.warn((Object)this, (String)("Can't interpret string for timeout: " + obj));
                    }
                } else {
                    Log.warn((Object)this, (String)("Can't interpret timeout: " + obj));
                }
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.queryIterator != null) {
            this.queryIterator.close();
        }
        if (this.plan != null) {
            this.plan.close();
        }
        if (this.timeout1Alarm != null) {
            this.alarmClock.cancel(this.timeout1Alarm);
        }
        if (this.timeout2Alarm != null) {
            this.alarmClock.cancel(this.timeout2Alarm);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new QueryExecException("HTTP QueryExecution has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        Object object = this.lockTimeout;
        synchronized (object) {
            if (this.queryIterator != null) {
                this.queryIterator.cancel();
            }
            this.isCancelled = true;
        }
    }

    @Override
    public ResultSet execSelect() {
        this.checkNotClosed();
        if (!this.query.isSelectType()) {
            throw new QueryExecException("Attempt to have ResultSet from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        ResultSet rs = this.execResultSet();
        return new ResultSetCheckCondition(rs, this);
    }

    @Override
    public Model execConstruct() {
        return this.execConstruct(GraphFactory.makeJenaDefaultModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model execConstruct(Model model) {
        this.checkNotClosed();
        try {
            Iterator<Triple> it = this.execConstructTriples();
            this.insertPrefixesInto(model);
            while (it.hasNext()) {
                Triple t = it.next();
                Statement stmt = ModelUtils.tripleToStatement(model, t);
                if (stmt == null) continue;
                model.add(stmt);
            }
        }
        finally {
            this.close();
        }
        return model;
    }

    @Override
    public Iterator<Triple> execConstructTriples() {
        this.checkNotClosed();
        if (!this.query.isConstructType()) {
            throw new QueryExecException("Attempt to get a CONSTRUCT model from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        this.query.setQueryResultStar(true);
        this.startQueryIterator();
        Template template = this.query.getConstructTemplate();
        return TemplateLib.calcTriples(template.getTriples(), this.queryIterator);
    }

    @Override
    public Iterator<Quad> execConstructQuads() {
        this.checkNotClosed();
        if (!this.query.isConstructType()) {
            throw new QueryExecException("Attempt to get a CONSTRUCT model from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        this.query.setQueryResultStar(true);
        this.startQueryIterator();
        Template template = this.query.getConstructTemplate();
        return TemplateLib.calcQuads(template.getQuads(), this.queryIterator);
    }

    @Override
    public Dataset execConstructDataset() {
        return this.execConstructDataset(DatasetFactory.create());
    }

    @Override
    public Dataset execConstructDataset(Dataset dataset) {
        DatasetGraph dsg = dataset.asDatasetGraph();
        try {
            this.execConstructQuads().forEachRemaining(dsg::add);
            this.insertPrefixesInto(dataset);
        }
        finally {
            this.close();
        }
        return dataset;
    }

    @Override
    public Model execDescribe() {
        return this.execDescribe(GraphFactory.makeJenaDefaultModel());
    }

    @Override
    public Model execDescribe(Model model) {
        this.checkNotClosed();
        if (!this.query.isDescribeType()) {
            throw new QueryExecException("Attempt to get a DESCRIBE result from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        this.query.setResultVars();
        if (this.query.getQueryPattern() == null) {
            this.query.setQueryPattern(new ElementGroup());
        }
        HashSet<RDFNode> set = new HashSet<RDFNode>();
        ResultSet qRes = this.execResultSet();
        this.insertPrefixesInto(model);
        if (qRes != null) {
            while (qRes.hasNext()) {
                QuerySolution rb = qRes.nextSolution();
                for (String varName : this.query.getResultVars()) {
                    RDFNode n = rb.get(varName);
                    set.add(n);
                }
            }
        }
        if (this.query.getResultURIs() != null) {
            for (Node n : this.query.getResultURIs()) {
                RDFNode rNode = ModelUtils.convertGraphNodeToRDFNode(n, this.dataset.getDefaultModel());
                set.add(rNode);
            }
        }
        List<DescribeHandler> dhList = DescribeHandlerRegistry.get().newHandlerList();
        this.getContext().put(ARQConstants.sysCurrentDataset, this.getDataset());
        for (DescribeHandler dh : dhList) {
            dh.start(model, this.getContext());
        }
        for (RDFNode n : set) {
            if (!(n instanceof Resource)) continue;
            for (DescribeHandler dh : dhList) {
                dh.describe((Resource)n);
            }
        }
        for (DescribeHandler dh : dhList) {
            dh.finish();
        }
        this.close();
        return model;
    }

    @Override
    public Iterator<Triple> execDescribeTriples() {
        return ModelUtils.statementsToTriples((Iterator<Statement>)this.execDescribe().listStatements());
    }

    @Override
    public boolean execAsk() {
        this.checkNotClosed();
        if (!this.query.isAskType()) {
            throw new QueryExecException("Attempt to have boolean from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        this.startQueryIterator();
        boolean r = this.queryIterator.hasNext();
        this.close();
        return r;
    }

    @Override
    public void setTimeout(long timeout, TimeUnit timeUnit) {
        long x = QueryExecutionBase.asMillis(timeout, timeUnit);
        this.timeout1 = -1L;
        this.timeout2 = x;
    }

    @Override
    public void setTimeout(long timeout) {
        this.setTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        long x1 = QueryExecutionBase.asMillis(timeout1, timeUnit1);
        long x2 = QueryExecutionBase.asMillis(timeout2, timeUnit2);
        this.timeout1 = x1;
        this.timeout2 = timeout2 < 0L ? -1L : x2;
    }

    @Override
    public void setTimeout(long timeout1, long timeout2) {
        this.setTimeout(timeout1, TimeUnit.MILLISECONDS, timeout2, TimeUnit.MILLISECONDS);
    }

    private static long asMillis(long duration, TimeUnit timeUnit) {
        return duration < 0L ? duration : timeUnit.toMillis(duration);
    }

    @Override
    public long getTimeout1() {
        return this.timeout1;
    }

    @Override
    public long getTimeout2() {
        return this.timeout2;
    }

    private static boolean isTimeoutSet(long x) {
        return x >= 0L;
    }

    protected void execInit() {
    }

    private ResultSet asResultSet(QueryIterator qIter) {
        Model model = null;
        model = this.dataset != null ? this.dataset.getDefaultModel() : ModelFactory.createDefaultModel();
        ResultSetStream rStream = new ResultSetStream(this.query.getResultVars(), model, qIter);
        return rStream;
    }

    private void startQueryIterator() {
        this.execInit();
        if (this.queryIterator != null) {
            Log.warn((Object)this, (String)"Query iterator has already been started");
        }
        if (!QueryExecutionBase.isTimeoutSet(this.timeout1) && !QueryExecutionBase.isTimeoutSet(this.timeout2)) {
            this.queryIterator = this.getPlan().iterator();
            return;
        }
        if (!QueryExecutionBase.isTimeoutSet(this.timeout1) && QueryExecutionBase.isTimeoutSet(this.timeout2)) {
            TimeoutCallback callback;
            this.expectedCallback = callback = new TimeoutCallback();
            this.timeout2Alarm = this.alarmClock.add((Runnable)callback, this.timeout2);
            this.queryIterator = this.getPlan().iterator();
            return;
        }
        TimeoutCallback callback = new TimeoutCallback();
        this.timeout1Alarm = this.alarmClock.add((Runnable)callback, this.timeout1);
        this.expectedCallback = callback;
        this.queryIterator = this.getPlan().iterator();
        this.queryIterator = new QueryIteratorTimer2(this.queryIterator);
        if (this.isCancelled) {
            this.queryIterator.cancel();
        }
    }

    private ResultSet execResultSet() {
        this.startQueryIterator();
        return this.asResultSet(this.queryIterator);
    }

    public Plan getPlan() {
        if (this.plan == null) {
            DatasetGraph dsg = QueryExecutionBase.prepareDataset(this.dataset, this.query);
            Binding inputBinding = null;
            if (this.initialBinding != null) {
                inputBinding = BindingUtils.asBinding(this.initialBinding);
            }
            if (inputBinding == null) {
                inputBinding = BindingRoot.create();
            }
            this.plan = this.qeFactory.create(this.query, dsg, inputBinding, this.getContext());
        }
        return this.plan;
    }

    private void insertPrefixesInto(Model model) {
        try {
            if (this.dataset != null) {
                Model m = this.dataset.getDefaultModel();
                model.setNsPrefixes((PrefixMapping)m);
            }
            model.setNsPrefixes(this.query.getPrefixMapping());
        }
        catch (Exception ex) {
            Log.warn((Object)this, (String)("Exception in insertPrefixes: " + ex.getMessage()), (Throwable)ex);
        }
    }

    private void insertPrefixesInto(Dataset ds) {
        this.insertPrefixesInto(ds.getDefaultModel());
    }

    private static String labelForQuery(Query q) {
        if (q.isSelectType()) {
            return "SELECT";
        }
        if (q.isConstructType()) {
            return "CONSTRUCT";
        }
        if (q.isDescribeType()) {
            return "DESCRIBE";
        }
        if (q.isAskType()) {
            return "ASK";
        }
        return "<<unknown>>";
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    private static DatasetGraph prepareDataset(Dataset dataset, Query query) {
        if (dataset != null) {
            return dataset.asDatasetGraph();
        }
        if (!query.hasDatasetDescription()) {
            throw new QueryExecException("No dataset description for query");
        }
        String baseURI = query.getBaseURI();
        if (baseURI == null) {
            baseURI = IRIResolver.chooseBaseURI().toString();
        }
        DatasetGraph dsg = DatasetUtils.createDatasetGraph(query.getDatasetDescription(), baseURI);
        return dsg;
    }

    @Override
    public void setInitialBinding(QuerySolution startSolution) {
        this.initialBinding = startSolution;
    }

    public void setInitialBindings(ResultSet table) {
        throw new UnsupportedOperationException("setInitialBindings(ResultSet)");
    }

    private class QueryIteratorTimer2
    extends QueryIteratorWrapper {
        long yieldCount;
        boolean resetDone;

        public QueryIteratorTimer2(QueryIterator qIter) {
            super(qIter);
            this.yieldCount = 0L;
            this.resetDone = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Binding moveToNextBinding() {
            Binding b = super.moveToNextBinding();
            ++this.yieldCount;
            if (!this.resetDone) {
                Object object = QueryExecutionBase.this.lockTimeout;
                synchronized (object) {
                    TimeoutCallback callback = new TimeoutCallback();
                    QueryExecutionBase.this.expectedCallback = callback;
                    if (QueryExecutionBase.this.isCancelled) {
                        throw new QueryCancelledException();
                    }
                    if (QueryExecutionBase.this.timeout1Alarm != null) {
                        QueryExecutionBase.this.alarmClock.cancel(QueryExecutionBase.this.timeout1Alarm);
                        QueryExecutionBase.this.timeout1Alarm = null;
                    }
                    if (QueryExecutionBase.this.timeout2 > 0L) {
                        QueryExecutionBase.this.timeout2Alarm = QueryExecutionBase.this.alarmClock.add((Runnable)callback, QueryExecutionBase.this.timeout2);
                    }
                    this.resetDone = true;
                }
            }
            return b;
        }
    }

    class TimeoutCallback
    implements Runnable {
        TimeoutCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = QueryExecutionBase.this.lockTimeout;
            synchronized (object) {
                if (QueryExecutionBase.this.expectedCallback == this) {
                    QueryExecutionBase.this.abort();
                }
            }
        }
    }
}

