/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.store.DatasetGraphSwitchable;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.sys.DatabaseConnection;
import org.apache.jena.tdb2.sys.StoreConnection;

public class TDBInternal {
    public static NodeId getNodeId(Dataset ds, Node node) {
        return TDBInternal.getNodeId(ds.asDatasetGraph(), node);
    }

    public static NodeId getNodeId(DatasetGraph ds, Node node) {
        DatasetGraphTDB dsg = TDBInternal.getDatasetGraphTDB(ds);
        return TDBInternal.getNodeId(dsg, node);
    }

    public static NodeId getNodeId(DatasetGraphTDB dsg, Node node) {
        if (dsg == null) {
            return null;
        }
        NodeTable nodeTable = dsg.getQuadTable().getNodeTupleTable().getNodeTable();
        NodeId nodeId = nodeTable.getNodeIdForNode(node);
        return nodeId;
    }

    public static Node getNode(Dataset ds, NodeId nodeId) {
        return TDBInternal.getNode(ds.asDatasetGraph(), nodeId);
    }

    public static Node getNode(DatasetGraph ds, NodeId nodeId) {
        DatasetGraphTDB dsg = TDBInternal.getDatasetGraphTDB(ds);
        return TDBInternal.getNode(dsg, nodeId);
    }

    public static Node getNode(DatasetGraphTDB dsg, NodeId nodeId) {
        if (dsg == null) {
            return null;
        }
        NodeTable nodeTable = dsg.getQuadTable().getNodeTupleTable().getNodeTable();
        Node node = nodeTable.getNodeForNodeId(nodeId);
        return node;
    }

    public static DatasetGraphTDB getDatasetGraphTDB(Dataset ds) {
        return TDBInternal.getDatasetGraphTDB(ds.asDatasetGraph());
    }

    public static DatasetGraphSwitchable getDatabaseContainer(DatasetGraph dsg) {
        if (dsg instanceof DatasetGraphSwitchable) {
            return (DatasetGraphSwitchable)dsg;
        }
        throw new TDBException("Not a TDB database container");
    }

    public static DatasetGraphTDB getDatasetGraphTDB(DatasetGraph dsg) {
        return TDBInternal.unwrap(dsg);
    }

    public static DatasetGraphTDB requireStorage(DatasetGraph dsg) {
        DatasetGraphTDB dsgtdb = TDBInternal.unwrap(dsg);
        if (dsgtdb == null) {
            throw new TDBException("Not a TDB database (argument is neither a switchable nor direct TDB DatasetGraph)");
        }
        return dsgtdb;
    }

    private static DatasetGraphTDB unwrap(DatasetGraph datasetGraph) {
        DatasetGraph dsg = datasetGraph;
        if (dsg instanceof DatasetGraphSwitchable) {
            dsg = ((DatasetGraphSwitchable)datasetGraph).get();
        }
        if (dsg instanceof DatasetGraphTDB) {
            return (DatasetGraphTDB)dsg;
        }
        return null;
    }

    public static synchronized void expel(DatasetGraph dsg) {
        Location locContainer = null;
        Location locStorage = null;
        if (dsg instanceof DatasetGraphSwitchable) {
            locContainer = ((DatasetGraphSwitchable)dsg).getLocation();
            dsg = ((DatasetGraphSwitchable)dsg).getWrapped();
        }
        if (dsg instanceof DatasetGraphTDB) {
            locStorage = ((DatasetGraphTDB)dsg).getLocation();
        }
        DatabaseConnection.internalExpel(locContainer, false);
        StoreConnection.internalExpel(locStorage, false);
    }

    public static void reset() {
        DatabaseConnection.internalReset();
        StoreConnection.internalReset();
    }

    public static boolean isBackedByTDB(DatasetGraph datasetGraph) {
        if (datasetGraph instanceof DatasetGraphSwitchable) {
            return true;
        }
        return datasetGraph instanceof DatasetGraphTDB;
    }
}

