/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.solver;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DynamicDatasets;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIteratorWrapper;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb2.TDB2;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.migrate.A2;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.sys.TDBInternal;

public class QueryEngineTDB
extends QueryEngineMain {
    private Binding initialInput;
    private boolean doingDynamicDatasetBySpecialDataset = false;
    protected static QueryEngineFactory factory = new QueryEngineFactoryTDB();

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory((QueryEngineFactory)factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory((QueryEngineFactory)factory);
    }

    protected QueryEngineTDB(Op op, DatasetGraphTDB dataset, Binding input, Context context) {
        super(op, (DatasetGraph)dataset, input, context);
        this.initialInput = input;
    }

    protected QueryEngineTDB(Query query, DatasetGraphTDB dataset, Binding input, Context cxt) {
        super(query, (DatasetGraph)dataset, input, cxt);
        DatasetDescription dsDesc = DatasetDescription.create((Query)query, (Context)this.context);
        if (dsDesc != null) {
            this.doingDynamicDatasetBySpecialDataset = true;
            this.dataset = DynamicDatasets.dynamicDataset((DatasetDescription)dsDesc, (DatasetGraph)dataset, (boolean)QueryEngineTDB.isUnionDefaultGraph(cxt));
        }
        this.initialInput = input;
    }

    private static boolean isUnionDefaultGraph(Context cxt) {
        return cxt.isTrue(TDB2.symUnionDefaultGraph1) || cxt.isTrue(TDB2.symUnionDefaultGraph2);
    }

    protected Op modifyOp(Op op) {
        op = Substitute.substitute((Op)op, (Binding)this.initialInput);
        op = super.modifyOp(op);
        if (!this.doingDynamicDatasetBySpecialDataset) {
            op = Algebra.toQuadForm((Op)op);
        }
        this.setOp(op);
        return op;
    }

    public QueryIterator eval(Op op, DatasetGraph dsg, Binding input, Context context) {
        if (QueryEngineTDB.isUnionDefaultGraph(context) && !this.doingDynamicDatasetBySpecialDataset) {
            op = A2.unionDefaultGraphQuads(op);
            Explain.explain((String)"REWRITE(Union default graph)", (Op)op, (Context)context);
        }
        Object results = super.eval(op, dsg, input, context);
        results = new QueryIteratorMaterializeBinding((QueryIterator)results);
        return results;
    }

    public long getMillis() {
        return -1L;
    }

    protected static class QueryEngineFactoryTDB
    implements QueryEngineFactory {
        protected QueryEngineFactoryTDB() {
        }

        private static boolean isHandledByTDB(DatasetGraph dataset) {
            return TDBInternal.isBackedByTDB(dataset);
        }

        protected DatasetGraphTDB dsgToQuery(DatasetGraph dataset) {
            try {
                return TDBInternal.requireStorage(dataset);
            }
            catch (TDBException ex) {
                throw new TDBException("Internal inconsistency: trying to execute query on unrecognized kind of DatasetGraph: " + Lib.className((Object)dataset));
            }
        }

        public boolean accept(Query query, DatasetGraph dataset, Context context) {
            return QueryEngineFactoryTDB.isHandledByTDB(dataset);
        }

        public Plan create(Query query, DatasetGraph dataset, Binding input, Context context) {
            QueryEngineTDB engine = new QueryEngineTDB(query, this.dsgToQuery(dataset), input, context);
            return engine.getPlan();
        }

        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return QueryEngineFactoryTDB.isHandledByTDB(dataset);
        }

        public Plan create(Op op, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineTDB engine = new QueryEngineTDB(op, this.dsgToQuery(dataset), binding, context);
            return engine.getPlan();
        }
    }

    static class QueryIteratorMaterializeBinding
    extends QueryIteratorWrapper {
        public QueryIteratorMaterializeBinding(QueryIterator qIter) {
            super(qIter);
        }

        protected Binding moveToNextBinding() {
            Binding b = super.moveToNextBinding();
            b = BindingFactory.materialize((Binding)b);
            return b;
        }
    }
}

