/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.sys;

import java.nio.ByteOrder;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.dboe.DBOpEnvException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sys {
    static final Logger log = LoggerFactory.getLogger((String)"org.apache.jena.dboe.Sys");
    public static final Logger syslog = LoggerFactory.getLogger((String)"org.apache.jena.dboe.System");
    public static final Logger errlog = LoggerFactory.getLogger((String)"org.apache.jena.dboe.System");
    public static final int SizeOfLong = 8;
    public static final int SizeOfInt = 4;
    public static final boolean is64bitSystem = Sys.determineIf64Bit();
    public static final ByteOrder NetworkOrder = ByteOrder.BIG_ENDIAN;
    public static final boolean isWindows = Sys.determineIfWindows();
    public static Executor executor = Executors.newCachedThreadPool();

    public static void init() {
    }

    public static void panic(Class<?> clazz, String string) {
        Log.error(clazz, (String)string);
        throw new DBOpEnvException(string);
    }

    private static boolean determineIfWindows() {
        String s = System.getProperty("os.name");
        if (s == null) {
            return false;
        }
        return s.startsWith("Windows ");
    }

    private static boolean determineIf64Bit() {
        String s = System.getProperty("sun.arch.data.model");
        if (s != null) {
            boolean b = s.equals("64");
            syslog.debug("System architecture: " + (b ? "64 bit" : "32 bit"));
            return b;
        }
        s = System.getProperty("java.vm.info");
        if (s == null) {
            log.warn("Can't determine the data model");
            return false;
        }
        log.debug("Can't determine the data model from 'sun.arch.data.model' - using java.vm.info");
        boolean b = s.contains("64");
        syslog.debug("System architecture: (from java.vm.info) " + (b ? "64 bit" : "32 bit"));
        return b;
    }
}

