/*
 * Decompiled with CFR 0.152.
 */
package shacl;

import java.io.OutputStream;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import jena.cmd.CmdGeneral;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RiotException;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.validation.ValidationProc;
import org.apache.jena.sys.JenaSystem;

public class shacl_validate
extends CmdGeneral {
    private ArgDecl argOutputText = new ArgDecl(false, "--text");
    private ArgDecl argData = new ArgDecl(true, "--data", "--datafile", "-d");
    private ArgDecl argShapes = new ArgDecl(true, "--shapes", "--shapesfile", "--shapefile", "-s");
    private ArgDecl argTargetNode = new ArgDecl(true, "--target", "--node", "-n");
    private String datafile = null;
    private String shapesfile = null;
    private String targetNode = null;
    private boolean textOutput = false;

    public static void main(String ... argv) {
        new shacl_validate(argv).mainRun();
    }

    public shacl_validate(String[] argv) {
        super(argv);
        super.add(this.argShapes, "--shapes", "Shapes file");
        super.add(this.argData, "--data", "Data file");
        super.add(this.argTargetNode, "--target", "Validate specific node [may use prefixes from the data]");
        super.add(this.argOutputText, "--text", "Output in concise text format");
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " [--target URI] --shapes shapesFile --data dataFile";
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        this.datafile = super.getValue(this.argData);
        this.shapesfile = super.getValue(this.argShapes);
        if (this.datafile == null && this.shapesfile == null && this.positionals.size() == 1) {
            this.datafile = (String)this.positionals.get(0);
            this.shapesfile = (String)this.positionals.get(0);
        }
        if (this.datafile == null) {
            throw new CmdException("Usage: " + this.getSummary());
        }
        if (this.shapesfile == null) {
            this.shapesfile = this.datafile;
        }
        this.textOutput = super.hasArg(this.argOutputText);
        if (this.contains(this.argTargetNode)) {
            this.targetNode = this.getValue(this.argTargetNode);
        }
    }

    @Override
    protected void exec() {
        ValidationReport report;
        Graph shapesGraph = this.load(this.shapesfile, "shapes file");
        Graph dataGraph = this.datafile.equals(this.shapesfile) ? shapesGraph : this.load(this.datafile, "data file");
        Node node = null;
        if (this.targetNode != null) {
            String x = dataGraph.getPrefixMapping().expandPrefix(this.targetNode);
            node = NodeFactory.createURI((String)x);
        }
        ValidationReport validationReport = report = node != null ? ValidationProc.simpleValidation((Graph)shapesGraph, (Graph)dataGraph, node, (boolean)this.isVerbose()) : ValidationProc.simpleValidation((Graph)shapesGraph, (Graph)dataGraph, (boolean)this.isVerbose());
        if (this.textOutput) {
            ShLib.printReport((ValidationReport)report);
        } else {
            RDFDataMgr.write((OutputStream)System.out, (Graph)report.getGraph(), (Lang)Lang.TTL);
        }
    }

    private Graph load(String filename, String scope) {
        try {
            Graph graph = RDFDataMgr.loadGraph((String)filename);
            return graph;
        }
        catch (RiotException ex) {
            System.err.println("Loading " + scope);
            throw ex;
        }
    }

    @Override
    protected String getCommandName() {
        return "shacl_validate";
    }

    static {
        LogCtl.setLogging();
        JenaSystem.init();
    }
}

