/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import java.io.IOException;
import java.io.InputStream;
import jena.cmd.ArgDecl;
import jena.cmd.CmdArgModule;
import jena.cmd.CmdException;
import jena.cmd.CmdGeneral;
import jena.cmd.ModBase;
import jena.cmd.TerminationException;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.util.FileUtils;

public class ModQueryIn
extends ModBase {
    protected final ArgDecl queryFileDecl = new ArgDecl(true, "query", "file");
    protected final ArgDecl querySyntaxDecl = new ArgDecl(true, "syntax", "syn", "in");
    protected final ArgDecl queryBaseDecl = new ArgDecl(true, "base");
    private Syntax defaultQuerySyntax = Syntax.syntaxARQ;
    private Syntax querySyntax = null;
    private String queryFilename = null;
    private String queryString = null;
    private Query query = null;
    private String baseURI = null;

    public ModQueryIn(Syntax defaultSyntax) {
        this.defaultQuerySyntax = defaultSyntax;
        this.querySyntax = defaultSyntax;
    }

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Query");
        cmdLine.add(this.queryFileDecl, "--query, --file", "File containing a query");
        cmdLine.add(this.querySyntaxDecl, "--syntax, --in", "Syntax of the query");
        cmdLine.add(this.queryBaseDecl, "--base", "Base URI for the query");
    }

    @Override
    public void processArgs(CmdArgModule cmdline) throws IllegalArgumentException {
        if (cmdline.contains(this.queryBaseDecl)) {
            this.baseURI = cmdline.getValue(this.queryBaseDecl);
        }
        if (cmdline.contains(this.queryFileDecl)) {
            this.queryFilename = cmdline.getValue(this.queryFileDecl);
            this.querySyntax = Syntax.guessQueryFileSyntax((String)this.queryFilename, (Syntax)this.defaultQuerySyntax);
        }
        if (cmdline.getNumPositional() == 0 && this.queryFilename == null) {
            cmdline.cmdError("No query string or query file");
        }
        if (cmdline.getNumPositional() > 1) {
            cmdline.cmdError("Only one query string allowed");
        }
        if (cmdline.getNumPositional() == 1 && this.queryFilename != null) {
            cmdline.cmdError("Either query string or query file - not both");
        }
        if (this.queryFilename == null) {
            String qs = cmdline.getPositionalArg(0);
            if (cmdline.matchesIndirect(qs)) {
                this.querySyntax = Syntax.guessQueryFileSyntax((String)qs, (Syntax)this.defaultQuerySyntax);
            }
            this.queryString = cmdline.indirect(qs);
        }
        if (cmdline.contains(this.querySyntaxDecl)) {
            String s = cmdline.getValue(this.querySyntaxDecl);
            Syntax syn = Syntax.lookup((String)s);
            if (syn == null) {
                cmdline.cmdError("Unrecognized syntax: " + s);
            }
            this.querySyntax = syn;
        }
    }

    public Syntax getQuerySyntax() {
        return this.querySyntax;
    }

    public Query getQuery() {
        if (this.query != null) {
            return this.query;
        }
        if (this.queryFilename != null && this.queryString != null) {
            System.err.println("Both query string and query file name given");
            throw new TerminationException(1);
        }
        if (this.queryFilename == null && this.queryString == null) {
            System.err.println("No query string and no query file name given");
            throw new TerminationException(1);
        }
        try {
            if (this.queryFilename != null) {
                if (this.queryFilename.equals("-")) {
                    try {
                        this.queryString = FileUtils.readWholeFileAsUTF8((InputStream)System.in);
                    }
                    catch (IOException ex) {
                        throw new CmdException("Error reading stdin", ex);
                    }
                } else {
                    this.query = QueryFactory.read((String)this.queryFilename, (String)this.baseURI, (Syntax)this.getQuerySyntax());
                    return this.query;
                }
            }
            this.query = QueryFactory.create((String)this.queryString, (String)this.baseURI, (Syntax)this.getQuerySyntax());
            return this.query;
        }
        catch (ARQInternalErrorException intEx) {
            System.err.println(intEx.getMessage());
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
            throw new TerminationException(99);
        }
        catch (JenaException ex) {
            System.err.println(ex.getMessage());
            throw new TerminationException(2);
        }
        catch (Exception ex) {
            System.out.flush();
            ex.printStackTrace(System.err);
            throw new TerminationException(98);
        }
    }
}

