/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import java.io.IOException;
import jena.cmd.ArgDecl;
import jena.cmd.CmdArgModule;
import jena.cmd.CmdGeneral;
import jena.cmd.ModBase;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.sse.SSE;

public class ModAlgebra
extends ModBase {
    protected final ArgDecl queryFileDecl = new ArgDecl(true, "query", "file");
    private String queryFilename = null;
    private String queryString = null;
    private Op op = null;

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Query");
        cmdLine.add(this.queryFileDecl, "--query, --file", "File containing an algebra query");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.contains(this.queryFileDecl)) {
            this.queryFilename = cmdLine.getValue(this.queryFileDecl);
            try {
                this.queryString = IO.readWholeFileAsUTF8((String)this.queryFilename);
            }
            catch (IOException e) {
                IO.exception((IOException)e);
            }
        }
        if (cmdLine.getNumPositional() == 0 && this.queryFilename == null) {
            cmdLine.cmdError("No query string or query file");
        }
        if (cmdLine.getNumPositional() > 1) {
            cmdLine.cmdError("Only one query string allowed");
        }
        if (cmdLine.getNumPositional() == 1 && this.queryFilename != null) {
            cmdLine.cmdError("Either query string or query file - not both");
        }
        if (this.queryFilename == null) {
            String qs = cmdLine.getPositionalArg(0);
            this.queryString = cmdLine.indirect(qs);
        }
    }

    public Op getOp() {
        if (this.op != null) {
            return this.op;
        }
        this.op = SSE.parseOp((String)this.queryString);
        if (this.op == null) {
            System.err.println("Failed to parse : " + this.queryString);
        }
        return this.op;
    }
}

