/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.query.Query;
import org.apache.jena.query.Syntax;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.sparql.lang.ParserARQ;
import org.apache.jena.sparql.lang.SPARQLParser;
import org.apache.jena.sparql.lang.SPARQLParserRegistry;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.util.FileManager;

public class QueryFactory {
    public static Query create(String queryString) {
        return QueryFactory.create(queryString, Syntax.defaultQuerySyntax);
    }

    public static Query create(String queryString, Syntax syntax) {
        return QueryFactory.create(queryString, null, syntax);
    }

    public static Query create(String queryString, String baseURI) {
        Query query = new Query();
        return QueryFactory.parse(query, queryString, baseURI, Syntax.defaultQuerySyntax);
    }

    public static Query create(String queryString, String baseURI, Syntax syntax) {
        Query query = new Query();
        return QueryFactory.parse(query, queryString, baseURI, syntax);
    }

    public static Query create() {
        return new Query();
    }

    public static Query make() {
        return QueryFactory.create();
    }

    public static Query create(Query originalQuery) {
        return originalQuery.cloneQuery();
    }

    public static Query parse(Query query, String queryString, String baseURI, Syntax syntaxURI) {
        if (syntaxURI == null) {
            syntaxURI = query.getSyntax();
        } else {
            query.setSyntax(syntaxURI);
        }
        SPARQLParser parser = SPARQLParser.createParser(syntaxURI);
        if (parser == null) {
            throw new UnsupportedOperationException("Unrecognized syntax for parsing: " + syntaxURI);
        }
        if (query.getResolver() == null) {
            IRIResolver resolver = null;
            try {
                resolver = baseURI != null ? IRIResolver.create(baseURI) : IRIResolver.create();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resolver == null) {
                resolver = IRIResolver.create("http://localhost/query/defaultBase#");
            }
            query.setResolver(resolver);
        }
        return parser.parse(query, queryString);
    }

    static boolean knownParserSyntax(Syntax syntaxURI) {
        return SPARQLParserRegistry.get().containsFactory(syntaxURI);
    }

    public static Query read(String url) {
        return QueryFactory.read(url, (StreamManager)null, null, null);
    }

    public static Query read(String url, String baseURI) {
        return QueryFactory.read(url, (StreamManager)null, baseURI, null);
    }

    public static Query read(String url, Syntax langURI) {
        return QueryFactory.read(url, (StreamManager)null, null, langURI);
    }

    public static Query read(String url, String baseURI, Syntax langURI) {
        return QueryFactory.read(url, (StreamManager)null, baseURI, langURI);
    }

    @Deprecated
    public static Query read(String url, FileManager filemanager, String baseURI, Syntax langURI) {
        if (filemanager == null) {
            filemanager = FileManager.getInternal();
        }
        String qStr = filemanager.readWholeFileAsUTF8(url);
        if (baseURI == null) {
            baseURI = url;
        }
        if (langURI == null) {
            langURI = Syntax.guessFileSyntax(url);
        }
        return QueryFactory.create(qStr, baseURI, langURI);
    }

    @Deprecated
    public static Query read(String url, StreamManager filemanager, String baseURI, Syntax langURI) {
        String qStr;
        if (filemanager == null) {
            filemanager = StreamManager.get();
        }
        try {
            qStr = IO.readWholeFileAsUTF8((InputStream)filemanager.open(url));
        }
        catch (IOException e2) {
            IO.exception((IOException)e2);
            qStr = null;
        }
        if (baseURI == null) {
            baseURI = url;
        }
        if (langURI == null) {
            langURI = Syntax.guessFileSyntax(url);
        }
        return QueryFactory.create(qStr, baseURI, langURI);
    }

    public static Element createElement(String elementString) {
        return ParserARQ.parseElement(elementString);
    }

    public static Template createTemplate(String templateString) {
        return ParserARQ.parseTemplate(templateString);
    }
}

