/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationFactory;
import org.slf4j.Logger;

public class LogCtl {
    private static final boolean hasLog4j1 = LogCtl.hasClass("org.slf4j.impl.Log4jLoggerFactory");
    private static final boolean hasLog4j2 = LogCtl.hasClass("org.apache.logging.slf4j.Log4jLoggerFactory");
    private static String log4j2setup = StrUtils.strjoinNL("## Command default log4j2 setup : log4j2 properties syntax.", "status = error", "name = PropertiesConfig", "filters = threshold", "", "filter.threshold.type = ThresholdFilter", "filter.threshold.level = INFO", "appender.console.type = Console", "appender.console.name = STDOUT", "appender.console.layout.type = PatternLayout", "appender.console.layout.pattern = %d{HH:mm:ss} %-5p %-10c{1} :: %m%n", "#appender.console.layout.pattern = [%d{yyyy-MM-dd HH:mm:ss}] %-5p %-10c{1} :: %m%n", "rootLogger.level                  = INFO", "rootLogger.appenderRef.stdout.ref = STDOUT", "logger.jena.name  = org.apache.jena", "logger.jena.level = INFO", "logger.arq-exec.name  = org.apache.jena.arq.exec", "logger.arq-exec.level = INFO", "logger.riot.name  = org.apache.jena.riot", "logger.riot.level = INFO");
    private static String[] log4j2files = new String[]{"log4j2.properties", "log4j2.xml"};
    private static String defaultProperties = StrUtils.strjoinNL("handlers=org.apache.jena.atlas.logging.java.ConsoleHandlerStream");
    private static String JUL_LOGGING = "logging.properties";
    private static String JUL_PROPERTY = "java.util.logging.configuration";

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void set(Logger logger, String level) {
        LogCtl.setLevel(logger.getName(), level);
    }

    public static void setLevel(Class<?> logger, String level) {
        LogCtl.setLevel(logger.getName(), level);
    }

    public static void setLevel(Logger logger, String level) {
        LogCtl.setLevel(logger.getName(), level);
    }

    public static void setLevel(String logger, String level) {
        LogCtl.setLevelLog4j2(logger, level);
        LogCtl.setLevelJUL(logger, level);
    }

    public static String getLevel(Logger logger) {
        return LogCtl.getLevel(logger.getName());
    }

    public static String getLevel(Class<?> logger) {
        return LogCtl.getLevel(logger.getName());
    }

    public static String getLevel(String logger) {
        String s2 = LogCtl.getLevelLog4j2(logger);
        if (s2 != null) {
            return s2;
        }
        String s3 = LogCtl.getLevelJUL(logger);
        if (s3 != null) {
            return s3;
        }
        return null;
    }

    private static String getLevelJUL(String logger) {
        java.util.logging.Level level = java.util.logging.Logger.getLogger(logger).getLevel();
        if (level == null) {
            return null;
        }
        if (level == java.util.logging.Level.SEVERE) {
            return "ERROR";
        }
        return level.getName();
    }

    private static String getLevelLog4j2(String logger) {
        if (!hasLog4j2) {
            return null;
        }
        Level level = LogManager.getLogger((String)logger).getLevel();
        if (level != null) {
            return level.toString();
        }
        return null;
    }

    private static void setLevelJUL(String logger, String levelName) {
        java.util.logging.Level level = java.util.logging.Level.ALL;
        if (levelName == null) {
            level = null;
        } else if (levelName.equalsIgnoreCase("info")) {
            level = java.util.logging.Level.INFO;
        } else if (levelName.equalsIgnoreCase("debug")) {
            level = java.util.logging.Level.FINE;
        } else if (levelName.equalsIgnoreCase("warn") || levelName.equalsIgnoreCase("warning")) {
            level = java.util.logging.Level.WARNING;
        } else if (levelName.equalsIgnoreCase("error") || levelName.equalsIgnoreCase("severe")) {
            level = java.util.logging.Level.SEVERE;
        } else if (levelName.equalsIgnoreCase("OFF")) {
            level = java.util.logging.Level.OFF;
        }
        java.util.logging.Logger.getLogger(logger).setLevel(level);
    }

    private static void setLevelLog4j2(String logger, String levelName) {
        if (!hasLog4j2) {
            return;
        }
        Level level = Level.ALL;
        if (levelName == null) {
            level = null;
        } else if (levelName.equalsIgnoreCase("info")) {
            level = Level.INFO;
        } else if (levelName.equalsIgnoreCase("debug")) {
            level = Level.DEBUG;
        } else if (levelName.equalsIgnoreCase("warn") || levelName.equalsIgnoreCase("warning")) {
            level = Level.WARN;
        } else if (levelName.equalsIgnoreCase("error") || levelName.equalsIgnoreCase("severe")) {
            level = Level.ERROR;
        } else if (levelName.equalsIgnoreCase("fatal")) {
            level = Level.FATAL;
        } else if (levelName.equalsIgnoreCase("OFF")) {
            level = Level.OFF;
        }
        try {
            if (!logger.equals("")) {
                Configurator.setLevel((String)logger, (Level)level);
            } else {
                Configurator.setRootLevel((Level)level);
            }
        }
        catch (NoClassDefFoundError ex) {
            Log.warnOnce(LogCtl.class, "Log4j2 Configurator not found", LogCtl.class);
        }
    }

    public static void enable(Logger logger) {
        LogCtl.enable(logger.getName());
    }

    public static void enable(String logger) {
        LogCtl.setLevel(logger, "all");
    }

    public static void enable(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "ALL");
    }

    public static void disable(Logger logger) {
        LogCtl.setLevel(logger.getName(), "OFF");
    }

    public static void disable(String logger) {
        LogCtl.setLevel(logger, "OFF");
    }

    public static void disable(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "OFF");
    }

    public static void setInfo(String logger) {
        LogCtl.setLevel(logger, "info");
    }

    public static void setInfo(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "info");
    }

    public static void setWarn(String logger) {
        LogCtl.setLevel(logger, "warn");
    }

    public static void setWarn(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "warn");
    }

    public static void setError(String logger) {
        LogCtl.setLevel(logger, "error");
    }

    public static void setError(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "error");
    }

    public static void setLog4j() {
        System.err.println("Log4j1 supported removed. Please use setLog4j2.");
    }

    public static void setLog4j(String filename) {
        System.err.println("Log4j1 supported removed. Please use setLog4j2.");
    }

    public static void setLog4j2() {
        if (System.getProperty("log4j2.configurationFile") == null) {
            for (String fn : log4j2files) {
                File f = new File(fn);
                if (!f.exists()) continue;
                System.setProperty("log4j.configurationFile", "file:" + fn);
            }
        }
    }

    public static void setLog4j2(String filename) {
        if (!filename.startsWith("file:")) {
            filename = "file:" + filename;
        }
        System.setProperty("log4j.configurationFile", "file:" + filename);
    }

    public static void setCmdLogging() {
        LogCtl.setCmdLogging(log4j2setup);
    }

    public static void setCmdLogging(String defaultConfig) {
        if (System.getProperty("log4j.configurationFile") == null) {
            LogCtl.resetLogging(defaultConfig);
            System.setProperty("log4j.configurationFile", "set");
        }
    }

    public static void resetLogging(String configString) {
        if (hasLog4j1) {
            System.err.println("WARNING: slf4j-log4j1 adapter detected. Use log4j2.");
        }
        if (!hasLog4j2) {
            return;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(StrUtils.asUTF8bytes(configString));){
            LogCtl.resetLogging(inputStream, ".properties");
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private static void resetLogging(InputStream inputStream, String syntaxHint) throws IOException {
        ConfigurationSource source = new ConfigurationSource(inputStream);
        Object factory = syntaxHint.endsWith(".properties") ? new PropertiesConfigurationFactory() : ConfigurationFactory.getInstance();
        Configuration configuration = factory.getConfiguration(null, source);
        Configurator.initialize((Configuration)configuration);
    }

    public static void setJavaLogging() {
        if (System.getProperty(JUL_PROPERTY) != null) {
            return;
        }
        LogCtl.resetJavaLogging();
    }

    public static void resetJavaLogging() {
        Path p = Paths.get(JUL_LOGGING, new String[0]);
        if (Files.exists(p, new LinkOption[0])) {
            LogCtl.setJavaLogging(JUL_LOGGING);
            return;
        }
        if (LogCtl.setJavaLoggingClasspath(JUL_LOGGING)) {
            return;
        }
        LogCtl.setJavaLoggingDft();
    }

    private static void readJavaLoggingConfiguration(InputStream details) throws Exception {
        System.setProperty(JUL_PROPERTY, "set");
        java.util.logging.LogManager.getLogManager().readConfiguration(details);
    }

    private static boolean setJavaLoggingClasspath(String resourceName) {
        InputStream in = LogCtl.class.getClassLoader().getResourceAsStream(resourceName);
        if (in != null) {
            try {
                LogCtl.readJavaLoggingConfiguration(in);
                return true;
            }
            catch (Exception ex) {
                throw new AtlasException(ex);
            }
        }
        return false;
    }

    public static void setJavaLogging(String file) {
        try {
            InputStream details = new FileInputStream(file);
            details = new BufferedInputStream(details);
            LogCtl.readJavaLoggingConfiguration(details);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }

    public static void setJavaLoggingDft() {
        try {
            ByteArrayInputStream details = new ByteArrayInputStream(defaultProperties.getBytes("UTF-8"));
            LogCtl.readJavaLoggingConfiguration(details);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }
}

