/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.util.FileManager;

public final class WrappedReasonerFactory
implements ReasonerFactory {
    protected final ReasonerFactory factory;
    protected final Resource config;
    protected final Model schemaUnion = ModelFactory.createDefaultModel();
    public static final Property schemaURL = ResourceFactory.createProperty("http://jena.hpl.hp.com/2003/08/jms#schemaURL");

    public WrappedReasonerFactory(ReasonerFactory rrf, Resource config) {
        this.factory = rrf;
        this.config = config;
        WrappedReasonerFactory.loadSchemas(this.schemaUnion, config);
    }

    @Override
    public Reasoner create(Resource ignored) {
        Reasoner result = this.factory.create(this.config);
        return this.schemaUnion.isEmpty() ? result : result.bindSchema(this.schemaUnion);
    }

    private static Model loadSchemas(Model schema, Resource R) {
        StmtIterator schemas = R.listProperties(schemaURL);
        if (schemas.hasNext()) {
            Log.error(WrappedReasonerFactory.class, (String)"ERROR: detected obsolete use of jms:schemaURL when wrapping a reasoner factory");
        }
        while (schemas.hasNext()) {
            Statement s = schemas.nextStatement();
            Resource sc = s.getResource();
            FileManager.get().readModel(schema, sc.getURI());
        }
        return schema;
    }

    @Override
    public Model getCapabilities() {
        return this.factory.getCapabilities();
    }

    @Override
    public String getURI() {
        return this.factory.getURI();
    }
}

