/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterTriplePattern;
import org.apache.jena.sparql.serializer.SerializationContext;

class QueryIterAddTripleTerm
extends QueryIterTriplePattern {
    private final Triple triple;
    private final Var var;

    public QueryIterAddTripleTerm(QueryIterator chain, Var var, Triple triple, ExecutionContext execContext) {
        super(chain, triple, execContext);
        this.triple = triple;
        this.var = var;
    }

    @Override
    protected Binding moveToNextBinding() {
        Binding binding = super.moveToNextBinding();
        Triple matchedTriple = Substitute.substitute(this.triple, binding);
        if (!matchedTriple.isConcrete()) {
            return binding;
        }
        Node nt = NodeFactory.createTripleNode((Triple)matchedTriple);
        Binding b = BindingFactory.binding(binding, this.var, nt);
        return b;
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(this.getClass().getSimpleName() + ": [" + (Object)((Object)this.var) + "] " + this.triple);
    }
}

