/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.binding;

import java.util.Iterator;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.ResultBinding;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBase;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.binding.BindingProjectNamed;

public class BindingUtils {
    public static Binding asBinding(QuerySolution qSolution) {
        if (qSolution == null) {
            return null;
        }
        if (qSolution instanceof ResultBinding) {
            return new BindingProjectNamed(((ResultBinding)qSolution).getBinding());
        }
        BindingMap binding = BindingFactory.create();
        BindingUtils.addToBinding(binding, qSolution);
        return binding;
    }

    public static void addToBinding(BindingMap binding, QuerySolution qSolution) {
        if (qSolution == null) {
            return;
        }
        Iterator<String> iter = qSolution.varNames();
        while (iter.hasNext()) {
            String n = iter.next();
            RDFNode x = qSolution.get(n);
            if (Var.isBlankNodeVarName(n)) continue;
            try {
                binding.add(Var.alloc(n), x.asNode());
            }
            catch (ARQInternalErrorException ex) {
                Log.warn(BindingUtils.class, (String)("Attempt to bind " + n + " when already bound"));
            }
        }
    }

    public static void addAll(BindingMap dest, Binding src) {
        Iterator<Var> iter = src.vars();
        while (iter.hasNext()) {
            Var v = iter.next();
            Node n = src.get(v);
            dest.add(v, n);
        }
    }

    public static Binding merge(Binding bind1, Binding bind2) {
        BindingMap b2 = BindingFactory.create(bind1);
        Iterator<Var> vIter = bind2.vars();
        while (vIter.hasNext()) {
            Node n2;
            Var v = vIter.next();
            if (!b2.contains(v)) {
                b2.add(v, bind2.get(v));
                continue;
            }
            Node n1 = bind1.get(v);
            if (n1.equals((Object)(n2 = bind2.get(v)))) continue;
            Log.warn(BindingUtils.class, (String)("merge: Mismatch : " + n1 + " != " + n2));
        }
        return b2;
    }

    public static boolean equals(Binding b1, Binding b2) {
        return BindingBase.equals(b1, b2);
    }
}

