/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.setup;

import org.apache.jena.tdb.base.file.FileFactory;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.base.objectfile.ObjectFile;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.index.RangeIndex;
import org.apache.jena.tdb.index.RangeIndexBuilder;
import org.apache.jena.tdb.lib.ColumnMap;
import org.apache.jena.tdb.setup.ObjectFileBuilder;
import org.apache.jena.tdb.setup.StoreParams;
import org.apache.jena.tdb.setup.TupleIndexBuilder;
import org.apache.jena.tdb.store.tupletable.TupleIndex;
import org.apache.jena.tdb.store.tupletable.TupleIndexRecord;

public class BuilderStdDB {

    public static class ObjectFileBuilderStd
    implements ObjectFileBuilder {
        @Override
        public ObjectFile buildObjectFile(FileSet fileSet, String ext) {
            String filename = fileSet.filename(ext);
            if (fileSet.isMem()) {
                return FileFactory.createObjectFileMem(filename);
            }
            return FileFactory.createObjectFileDisk(filename);
        }
    }

    public static class TupleIndexBuilderStd
    implements TupleIndexBuilder {
        private final RangeIndexBuilder rangeIndexBuilder;

        public TupleIndexBuilderStd(RangeIndexBuilder rangeIndexBuilder) {
            this.rangeIndexBuilder = rangeIndexBuilder;
        }

        @Override
        public TupleIndex buildTupleIndex(FileSet fileSet, ColumnMap colMap, String name, StoreParams params) {
            RecordFactory recordFactory = new RecordFactory(8 * colMap.length(), 0);
            RangeIndex rIdx = this.rangeIndexBuilder.buildRangeIndex(fileSet, recordFactory, params);
            TupleIndexRecord tIdx = new TupleIndexRecord(colMap.length(), colMap, name, recordFactory, rIdx);
            return tIdx;
        }
    }
}

