/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintOp;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.validation.ValidationProc;
import org.apache.jena.shacl.vocabulary.SHACL;

public class ShAnd
extends ConstraintOp {
    private List<Shape> others;

    public ShAnd(List<Shape> others) {
        this.others = others;
    }

    @Override
    public Node getComponent() {
        return SHACL.AndConstraintComponent;
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Graph data, Node node) {
        for (Shape sh : this.others) {
            ValidationContext vCxt2 = new ValidationContext(vCxt);
            ValidationProc.execValidateShape(vCxt2, data, sh, node);
            boolean innerConforms = vCxt2.generateReport().conforms();
            if (innerConforms) continue;
            String msg = this.toString() + " at focusNode " + ShLib.displayStr(node);
            return new ReportItem(msg, node);
        }
        return null;
    }

    public String toString() {
        return "And" + this.others;
    }
}

