/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import java.util.function.Consumer;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.web.AuthSetup;

public class LibSec {
    public static AuthScheme authMode = AuthScheme.DIGEST;

    public static void withAuth(String urlStr, AuthSetup auth, Consumer<RDFConnection> action) {
        CredentialsProvider credsProvider = LibSec.credsProvider(auth);
        HttpHost target = new HttpHost(auth.host, auth.port, "http");
        BasicAuthCache authCache = new BasicAuthCache();
        if (authMode == AuthScheme.BASIC) {
            RFC2617Scheme authScheme = LibSec.authScheme(auth.realm);
            authCache.put(target, (org.apache.http.auth.AuthScheme)authScheme);
        }
        HttpClientContext httpContext = LibSec.httpContext((AuthCache)authCache, credsProvider);
        HttpClient httpClient = LibSec.httpClient(auth);
        try (RDFConnection conn = RDFConnectionRemote.create().destination(urlStr).httpClient(httpClient).httpContext((HttpContext)httpContext).build();){
            action.accept(conn);
        }
    }

    private static RFC2617Scheme authScheme(String realm) {
        switch (authMode) {
            case BASIC: {
                return LibSec.authBasicScheme(realm);
            }
            case DIGEST: {
                return LibSec.authDigestScheme(realm);
            }
        }
        throw new InternalErrorException("RFC2617 auth scheme not reocgnized: " + authMode);
    }

    private static DigestScheme authDigestScheme(String realm) {
        DigestScheme authScheme = new DigestScheme();
        authScheme.overrideParamter("realm", realm);
        authScheme.overrideParamter("nonce", "whatever");
        return authScheme;
    }

    private static BasicScheme authBasicScheme(String realm) {
        BasicScheme authScheme = new BasicScheme();
        return authScheme;
    }

    public static HttpClient httpClient(AuthSetup auth) {
        CredentialsProvider credsProvider = LibSec.credsProvider(auth);
        CloseableHttpClient client = HttpOp.createPoolingHttpClientBuilder().setDefaultCredentialsProvider(credsProvider).build();
        return client;
    }

    public static HttpClient httpClient(String host, int port, String user, String password, String realm) {
        AuthSetup auth = new AuthSetup(host, Integer.valueOf(port), user, password, realm);
        return LibSec.httpClient(auth);
    }

    public static HttpClientContext httpContext(AuthCache authCache, CredentialsProvider provider) {
        HttpClientContext localContext = HttpClientContext.create();
        return LibSec.httpContext(localContext, authCache, provider);
    }

    public static HttpClientContext httpContext(HttpClientContext localContext, AuthCache authCache, CredentialsProvider provider) {
        if (authCache != null) {
            localContext.setAuthCache(authCache);
        }
        localContext.setCredentialsProvider(provider);
        return localContext;
    }

    public static CredentialsProvider credsProvider(AuthSetup auth) {
        return LibSec.credsProvider(auth.host, auth.port, auth.user, auth.password);
    }

    private static CredentialsProvider credsProvider(String host, int port, String user, String password) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(user, password));
        return credsProvider;
    }
}

