/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.prefixes;

import java.util.Map;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.dboe.storage.prefixes.PrefixMapI;
import org.apache.jena.shared.PrefixMapping;

public class PrefixMappingOverPrefixMapI
implements PrefixMapping {
    private PrefixMapI pmap;

    PrefixMappingOverPrefixMapI(PrefixMapI pmap) {
        this.pmap = pmap;
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.pmap.add(prefix, uri);
        return this;
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        this.pmap.delete(prefix);
        return this;
    }

    public PrefixMapping clearNsPrefixMap() {
        this.pmap.clear();
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            String prefix = e.getKey();
            String iriStr = e.getValue();
            this.pmap.add(prefix, iriStr);
        }
        return this;
    }

    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        Map emap = map.getNsPrefixMap();
        for (Map.Entry e : emap.entrySet()) {
            String prefix = (String)e.getKey();
            String iriStr = (String)e.getValue();
            if (this.pmap.containPrefix(prefix)) continue;
            this.pmap.add(prefix, iriStr);
        }
        return this;
    }

    public String getNsPrefixURI(String prefix) {
        return this.pmap.getMapping().get(prefix);
    }

    public String getNsURIPrefix(String uri) {
        Pair<String, String> abbrev = this.pmap.abbrev(uri);
        if (abbrev == null) {
            return null;
        }
        return (String)abbrev.getLeft();
    }

    public Map<String, String> getNsPrefixMap() {
        return this.pmap.getMappingCopy();
    }

    public String expandPrefix(String prefixed) {
        String str = this.pmap.expand(prefixed);
        if (str == null) {
            return prefixed;
        }
        return str;
    }

    public String shortForm(String uri) {
        String s = this.pmap.abbreviate(uri);
        if (s == null) {
            return uri;
        }
        return s;
    }

    public String qnameFor(String uri) {
        return this.pmap.abbreviate(uri);
    }

    public boolean hasNoMappings() {
        return this.pmap.isEmpty();
    }

    public int numPrefixes() {
        return this.pmap.size();
    }

    public PrefixMapping lock() {
        return this;
    }

    public boolean samePrefixMappingAs(PrefixMapping other) {
        return this.getNsPrefixMap().equals(other.getNsPrefixMap());
    }

    public String toString() {
        return "PrefixMappingOverPrefixMapI:" + this.pmap.toString();
    }
}

