/*
 * Decompiled with CFR 0.152.
 */
package tdb.tools;

import java.util.Iterator;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.store.tupletable.TupleIndex;
import org.apache.jena.tdb.sys.SetupTDB;

public class tdbgenindex {
    public static void main(String ... argv) {
        boolean dftValueLength;
        int dftKeyLength;
        String primary;
        if (argv.length != 4) {
            System.err.println("Usage: " + Lib.classShortName(tdbgenindex.class) + " srcLocation srcIndex dstLocation dstIndex");
            System.exit(1);
        }
        Location srcLoc = Location.create((String)argv[0]);
        String srcIndexName = argv[1];
        Location dstLoc = Location.create((String)argv[2]);
        String dstIndexName = argv[3];
        boolean readCacheSize = false;
        int writeCacheSize = -1;
        if (srcIndexName.length() != dstIndexName.length()) {
            System.err.println("srcIndexName.length() != dstIndexName.length() " + srcIndexName + " :: " + dstIndexName);
            System.exit(1);
        }
        if (srcIndexName.length() == 3) {
            primary = "SPO";
            dftKeyLength = 24;
            dftValueLength = false;
        } else if (srcIndexName.length() == 4) {
            primary = "GSPO";
            dftKeyLength = 32;
            dftValueLength = false;
        } else {
            System.err.println("indexlength != 3 or 4");
            System.exit(1);
            primary = null;
            dftKeyLength = 0;
            dftValueLength = false;
        }
        TupleIndex srcIdx = SetupTDB.makeTupleIndex((Location)srcLoc, (String)primary, (String)srcIndexName, (String)srcIndexName, (int)dftKeyLength);
        TupleIndex dstIdx = SetupTDB.makeTupleIndex((Location)dstLoc, (String)primary, (String)dstIndexName, (String)dstIndexName, (int)dftKeyLength);
        Iterator iter = srcIdx.all();
        while (iter.hasNext()) {
            Tuple tuple = (Tuple)iter.next();
            dstIdx.add(tuple);
        }
        srcIdx.close();
        dstIdx.close();
    }
}

