/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.Transactional;

public abstract class DatasetGraphTrackActive
extends DatasetGraphWrapper {
    @Override
    protected abstract DatasetGraph get();

    protected DatasetGraphTrackActive() {
        super(null);
    }

    protected abstract void checkActive();

    protected abstract void checkNotActive();

    @Override
    public final void begin(TxnType txnType) {
        this.checkNotActive();
        this._begin(txnType);
    }

    @Override
    public final void begin(ReadWrite readWrite) {
        this.checkNotActive();
        this._begin(TxnType.convert(readWrite));
    }

    @Override
    public final boolean promote() {
        this.checkActive();
        return this._promote();
    }

    @Override
    public final boolean promote(Transactional.Promote promoteMode) {
        this.checkActive();
        return this._promote(promoteMode);
    }

    @Override
    public final void commit() {
        this.checkActive();
        this._commit();
    }

    @Override
    public final void abort() {
        this.checkActive();
        this._abort();
    }

    @Override
    public final void end() {
        this._end();
    }

    @Override
    public abstract boolean isInTransaction();

    protected abstract void _begin(TxnType var1);

    protected boolean _promote() {
        Transactional.Promote promoteMode = Transactional.Promote.ISOLATED;
        TxnType txnType = this.transactionType();
        if (txnType == TxnType.READ_COMMITTED_PROMOTE) {
            promoteMode = Transactional.Promote.READ_COMMITTED;
        }
        return this._promote(promoteMode);
    }

    protected abstract boolean _promote(Transactional.Promote var1);

    protected abstract void _commit();

    protected abstract void _abort();

    protected abstract void _end();

    @Override
    public void close() {
        if (this.isInTransaction()) {
            this.abort();
        }
        this._close();
    }

    protected abstract void _close();
}

