/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.jmap.cassandra.cucumber;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

import cucumber.api.CucumberOptions;
import cucumber.api.junit.Cucumber;

@RunWith(Cucumber.class)
@CucumberOptions(features = {
    "classpath:cucumber/sharing/SharingParentMailboxWithAndWithoutChildren.feature",
    "classpath:cucumber/sharing/SharingChildrenWithoutSharingParent.feature",
    "classpath:cucumber/sharing/SharingMailboxWithOtherDomain.feature",
    "classpath:cucumber/sharing/MailboxCreationAndSharing.feature",
    "classpath:cucumber/sharing/MailboxDeletionAndSharing.feature",
    "classpath:cucumber/sharing/MoveMailboxAndSharing.feature",
    "classpath:cucumber/sharing/RenamingMailboxAndSharing.feature" },
    glue = { "org.apache.james.jmap.methods.integration", "org.apache.james.jmap.cassandra.cucumber" },
    tags = {"~@Ignore"},
    strict = true)
public class CassandraMailboxSharingTest {

    @BeforeClass
    public static void init() {
        CucumberCassandraSingleton.cassandraServer.start();
    }

    @AfterClass
    public static void after() {
        CucumberCassandraSingleton.cassandraServer.stop();
    }

}
