/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.mailbox.indexer.events;

import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MailboxPath;

import com.google.common.base.Objects;

public class MessageDeletedEvent implements ImpactingMessageEvent {

    private final MailboxPath mailboxPath;
    private final MessageUid uid;

    public MessageDeletedEvent(MailboxPath mailboxPath, MessageUid uid) {
        this.mailboxPath = mailboxPath;
        this.uid = uid;
    }

    @Override
    public MessageUid getUid() {
        return uid;
    }

    @Override
    public MailboxPath getMailboxPath() {
        return mailboxPath;
    }

    @Override
    public ImpactingEventType getType() {
        return ImpactingEventType.Deletion;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessageDeletedEvent that = (MessageDeletedEvent) o;
        return Objects.equal(uid, that.uid) && Objects.equal(mailboxPath, that.mailboxPath);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(uid, mailboxPath);
    }
}
