# Guice-JPA installation guide

## Building

### Requirements

 - Java 8 SDK
 - Docker
 - Maven 3

### Building the artifacts

An usual compilation using maven of this [Git repository content](https://github.com/apache/james-project) will produce
two artifacts into server/container/guice/jpa-guice/target directory:

 - james-server-jpa-guice.jar
 - james-server-jpa-guice.lib

You can for example run in the base of this git repository:

```
mvn clean install
```

## Running

### James Launch

To run james, you have to create a directory containing required configuration files.

James requires the configuration to be in a subfolder of working directory that is called **conf**. You can get a sample
directory for configuration from [dockerfiles/run/guice/jpa/destination/conf](https://github.com/apache/james-project/tree/master/dockerfiles/run/guice/jpa/destination/conf). You might need to adapt it to your needs.

You also need to generate a keystore in your conf folder with the following command:

```bash
$ keytool -genkey -alias james -keyalg RSA -keystore conf/keystore
```

Once everything is set up, you just have to run the jar with:

```bash
$ java -Dworking.directory=. -jar target/james-server-jpa-guice.jar
```
