/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;

public class PrefixUtil {
    public static Pair<SimpleString, RoutingType> getAddressAndRoutingType(SimpleString address, RoutingType defaultRoutingType, Map<SimpleString, RoutingType> prefixes) {
        for (Map.Entry<SimpleString, RoutingType> entry : prefixes.entrySet()) {
            if (!address.startsWith(entry.getKey())) continue;
            return new Pair((Object)PrefixUtil.removePrefix(address, entry.getKey()), (Object)entry.getValue());
        }
        return new Pair((Object)address, (Object)defaultRoutingType);
    }

    public static Pair<SimpleString, Set<RoutingType>> getAddressAndRoutingTypes(SimpleString address, Set<RoutingType> defaultRoutingTypes, Map<SimpleString, RoutingType> prefixes) {
        for (Map.Entry<SimpleString, RoutingType> entry : prefixes.entrySet()) {
            if (!address.startsWith(entry.getKey())) continue;
            HashSet<RoutingType> routingTypes = new HashSet<RoutingType>();
            routingTypes.add(entry.getValue());
            return new Pair((Object)PrefixUtil.removePrefix(address, entry.getKey()), routingTypes);
        }
        return new Pair((Object)address, defaultRoutingTypes);
    }

    public static SimpleString getAddress(SimpleString address, Map<SimpleString, RoutingType> prefixes) {
        for (Map.Entry<SimpleString, RoutingType> entry : prefixes.entrySet()) {
            if (!address.startsWith(entry.getKey())) continue;
            return PrefixUtil.removePrefix(address, entry.getKey());
        }
        return address;
    }

    private static SimpleString removePrefix(SimpleString string, SimpleString prefix) {
        return string.subSeq(prefix.length(), string.length());
    }
}

