/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import io.netty.buffer.ByteBuf;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacket;

public class SessionSendMessage
extends MessagePacket {
    private boolean requiresResponse;
    private final transient SendAcknowledgementHandler handler;

    public SessionSendMessage(ICoreMessage message, boolean requiresResponse, SendAcknowledgementHandler handler) {
        super((byte)71, message);
        this.handler = handler;
        this.requiresResponse = requiresResponse;
    }

    public SessionSendMessage(CoreMessage message) {
        super((byte)71, message);
        this.handler = null;
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public SendAcknowledgementHandler getHandler() {
        return this.handler;
    }

    @Override
    public int expectedEncodeSize() {
        return this.message.getEncodeSize() + 13 + 1;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        this.message.sendBuffer(buffer.byteBuf(), 0);
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        ByteBuf messageBuffer = this.copyMessageBuffer(buffer.byteBuf(), 1);
        this.message.receiveBuffer(messageBuffer);
        buffer.readerIndex(buffer.capacity() - 1);
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", requiresResponse=" + this.requiresResponse);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionSendMessage)) {
            return false;
        }
        SessionSendMessage other = (SessionSendMessage)obj;
        return this.requiresResponse == other.requiresResponse;
    }
}

