/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.TemporaryResolutionException;
import org.apache.james.dnsservice.library.MXHostAddressIterator;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.server.core.MailImpl;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.HostAddress;
import org.apache.mailet.LookupException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JamesMailetContext
implements MailetContext,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JamesMailetContext.class);
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    protected DNSService dns;
    private UsersRepository localusers;
    private MailQueue rootMailQueue;
    private DomainList domains;
    private MailAddress postmaster;

    @Inject
    public void retrieveRootMailQueue(MailQueueFactory<?> mailQueueFactory) {
        this.rootMailQueue = mailQueueFactory.createQueue("spool");
    }

    @Inject
    public void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    @Inject
    public void setUsersRepository(UsersRepository localusers) {
        this.localusers = localusers;
    }

    @Inject
    public void setDomainList(DomainList domains) {
        this.domains = domains;
    }

    public Collection<String> getMailServers(Domain host) {
        try {
            return this.dns.findMXRecords(host.asString());
        }
        catch (TemporaryResolutionException e) {
            return ImmutableSet.of();
        }
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object object) {
        this.attributes.put(key, object);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public void bounce(Mail mail, String message) throws MessagingException {
        this.bounce(mail, message, this.getPostmaster());
    }

    public void bounce(Mail mail, String message, MailAddress bouncer) throws MessagingException {
        if (mail.getSender() == null) {
            LOGGER.info("Mail to be bounced contains a null (<>) reverse path.  No bounce will be sent.");
            return;
        }
        LOGGER.info("Processing a bounce request for a message with a reverse path of {}", (Object)mail.getSender());
        MailImpl reply = this.rawBounce(mail, message);
        if (bouncer != null) {
            reply.getMessage().setFrom((Address)bouncer.toInternetAddress());
        }
        reply.getMessage().saveChanges();
        reply.setSender(null);
        this.sendMail((Mail)reply);
        LifecycleUtil.dispose((Object)reply);
    }

    public List<String> dnsLookup(String s, MailetContext.RecordType recordType) throws LookupException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    private MailImpl rawBounce(Mail mail, String bounceText) throws MessagingException {
        MimeMessage original = mail.getMessage();
        MimeMessage reply = (MimeMessage)original.reply(false);
        reply.setSubject("Re: " + original.getSubject());
        reply.setSentDate(new Date());
        HashSet<MailAddress> recipients = new HashSet<MailAddress>();
        recipients.add(mail.getSender());
        InternetAddress[] addr = new InternetAddress[]{new InternetAddress(mail.getSender().toString())};
        reply.setRecipients(Message.RecipientType.TO, (Address[])addr);
        reply.setFrom((Address)new InternetAddress(((MailAddress)mail.getRecipients().iterator().next()).toString()));
        reply.setText(bounceText);
        reply.setHeader("Message-ID", "replyTo-" + mail.getName());
        return new MailImpl("replyTo-" + mail.getName(), new MailAddress(((MailAddress)mail.getRecipients().iterator().next()).toString()), recipients, reply);
    }

    public boolean isLocalUser(String name) {
        if (name == null) {
            return false;
        }
        try {
            if (!name.contains("@")) {
                try {
                    return this.isLocalEmail(new MailAddress(name.toLowerCase(Locale.US), this.domains.getDefaultDomain().asString()));
                }
                catch (DomainListException e) {
                    LOGGER.error("Unable to access DomainList", (Throwable)e);
                    return false;
                }
            }
            return this.isLocalEmail(new MailAddress(name.toLowerCase(Locale.US)));
        }
        catch (ParseException e) {
            LOGGER.info("Error checking isLocalUser for user {}", (Object)name, (Object)e);
            return false;
        }
    }

    public boolean isLocalEmail(MailAddress mailAddress) {
        if (mailAddress != null) {
            if (!this.isLocalServer(mailAddress.getDomain())) {
                return false;
            }
            try {
                return this.localusers.contains(this.localusers.getUser(mailAddress));
            }
            catch (UsersRepositoryException e) {
                LOGGER.error("Unable to access UsersRepository", (Throwable)e);
            }
        }
        return false;
    }

    public MailAddress getPostmaster() {
        return this.postmaster;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    @Deprecated
    public Iterator<HostAddress> getSMTPHostAddresses(Domain domainName) {
        try {
            return new MXHostAddressIterator(this.dns.findMXRecords(domainName.asString()).iterator(), this.dns, false);
        }
        catch (TemporaryResolutionException e) {
            return ImmutableSet.of().iterator();
        }
    }

    public String getServerInfo() {
        return "Apache JAMES";
    }

    public boolean isLocalServer(Domain domain) {
        try {
            return this.domains.containsDomain(domain);
        }
        catch (DomainListException e) {
            LOGGER.error("Unable to retrieve domains", (Throwable)e);
            return false;
        }
    }

    @Deprecated
    public void log(String arg0) {
        LOGGER.info(arg0);
    }

    @Deprecated
    public void log(String arg0, Throwable arg1) {
        LOGGER.info(arg0, arg1);
    }

    @Deprecated
    public void log(MailetContext.LogLevel logLevel, String s) {
        switch (logLevel) {
            case INFO: {
                LOGGER.info(s);
                break;
            }
            case WARN: {
                LOGGER.warn(s);
                break;
            }
            case ERROR: {
                LOGGER.error(s);
                break;
            }
            default: {
                LOGGER.debug(s);
            }
        }
    }

    @Deprecated
    public void log(MailetContext.LogLevel logLevel, String s, Throwable throwable) {
        switch (logLevel) {
            case INFO: {
                LOGGER.info(s, throwable);
                break;
            }
            case WARN: {
                LOGGER.warn(s, throwable);
                break;
            }
            case ERROR: {
                LOGGER.error(s, throwable);
                break;
            }
            default: {
                LOGGER.debug(s, throwable);
            }
        }
    }

    public void sendMail(MimeMessage message) throws MessagingException {
        MailAddress sender = new MailAddress((InternetAddress)message.getFrom()[0]);
        HashSet<MailAddress> recipients = new HashSet<MailAddress>();
        Address[] addresses = message.getAllRecipients();
        if (addresses != null) {
            for (Address address : addresses) {
                if (!(address instanceof InternetAddress)) continue;
                recipients.add(new MailAddress((InternetAddress)address));
            }
        }
        this.sendMail(sender, recipients, message);
    }

    public void sendMail(MailAddress sender, Collection<MailAddress> recipients, MimeMessage message) throws MessagingException {
        this.sendMail(sender, recipients, message, "root");
    }

    public void sendMail(Mail mail) throws MessagingException {
        this.sendMail(mail, "root");
    }

    public void sendMail(Mail mail, long delay, TimeUnit unit) throws MessagingException {
        this.sendMail(mail, "root", delay, unit);
    }

    public void sendMail(Mail mail, String state) throws MessagingException {
        mail.setAttribute("org.apache.james.SentByMailet", (Serializable)((Object)"true"));
        mail.setState(state);
        this.rootMailQueue.enQueue(mail);
    }

    public void sendMail(Mail mail, String state, long delay, TimeUnit unit) throws MessagingException {
        mail.setAttribute("org.apache.james.SentByMailet", (Serializable)((Object)"true"));
        mail.setState(state);
        this.rootMailQueue.enQueue(mail, delay, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMail(MailAddress sender, Collection<MailAddress> recipients, MimeMessage message, String state) throws MessagingException {
        MailImpl mail = new MailImpl(MailImpl.getId(), sender, recipients, message);
        try {
            this.sendMail((Mail)mail, state);
        }
        finally {
            LifecycleUtil.dispose((Object)mail);
        }
    }

    public void storeMail(MailAddress sender, MailAddress recipient, MimeMessage msg) {
        throw new UnsupportedOperationException("Was removed");
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        try {
            String postMasterAddress = config.getString("postmaster", "postmaster").toLowerCase(Locale.US);
            if (postMasterAddress.indexOf(64) < 0) {
                Domain domainName = this.domains.getDomains().stream().filter(domain -> !Domain.LOCALHOST.equals(domain)).findFirst().orElse(this.domains.getDefaultDomain());
                postMasterAddress = postMasterAddress + "@" + domainName.asString();
            }
            try {
                this.postmaster = new MailAddress(postMasterAddress);
                if (!this.domains.containsDomain(this.postmaster.getDomain())) {
                    LOGGER.warn("The specified postmaster address ( {} ) is not a local address.  This is not necessarily a problem, but it does mean that emails addressed to the postmaster will be routed to another server.  For some configurations this may cause problems.", (Object)this.postmaster);
                }
            }
            catch (AddressException e) {
                throw new ConfigurationException("Postmaster address " + postMasterAddress + "is invalid", (Throwable)e);
            }
        }
        catch (DomainListException e) {
            throw new ConfigurationException("Unable to access DomainList", (Throwable)e);
        }
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

