/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.api.jmx.MailSpoolerMBean;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.util.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JamesMailSpooler
implements Runnable,
Disposable,
Configurable,
MailSpoolerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(JamesMailSpooler.class);
    public static final String SPOOL_PROCESSING = "spoolProcessing";
    private MailQueue queue;
    private int numThreads;
    private final AtomicInteger numActive = new AtomicInteger(0);
    private final AtomicInteger processingActive = new AtomicInteger(0);
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final MetricFactory metricFactory;
    private ExecutorService dequeueService;
    private ExecutorService workerService;
    private MailProcessor mailProcessor;
    private MailQueueFactory<?> queueFactory;
    private int numDequeueThreads;

    @Inject
    public JamesMailSpooler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    @Inject
    public void setMailQueueFactory(MailQueueFactory<?> queueFactory) {
        this.queueFactory = queueFactory;
    }

    @Inject
    public void setMailProcessor(MailProcessor mailProcessor) {
        this.mailProcessor = mailProcessor;
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.numDequeueThreads = config.getInt("dequeueThreads", 2);
        this.numThreads = config.getInt("threads", 100);
    }

    @PostConstruct
    public void init() {
        LOGGER.info("{} init...", (Object)this.getClass().getName());
        this.queue = this.queueFactory.createQueue("spool");
        LOGGER.info("{} uses {} Thread(s)", (Object)this.getClass().getName(), (Object)this.numThreads);
        this.active.set(true);
        this.workerService = JMXEnabledThreadPoolExecutor.newFixedThreadPool((String)"org.apache.james:type=component,component=mailetcontainer,name=mailspooler,sub-type=threadpool", (String)"spooler", (int)this.numThreads);
        this.dequeueService = JMXEnabledThreadPoolExecutor.newFixedThreadPool((String)"org.apache.james:type=component,component=mailetcontainer,name=mailspooler,sub-type=threadpool", (String)"dequeuer", (int)this.numDequeueThreads);
        for (int i = 0; i < this.numDequeueThreads; ++i) {
            Thread reader = new Thread((Runnable)this, "Dequeue Thread #" + i);
            this.dequeueService.execute(reader);
        }
    }

    @Override
    public void run() {
        LOGGER.info("Run {}: {}", (Object)this.getClass().getName(), (Object)Thread.currentThread().getName());
        LOGGER.info("Queue={}", (Object)this.queue);
        while (this.active.get()) {
            try {
                MailQueue.MailQueueItem queueItem = this.queue.deQueue();
                this.workerService.execute(() -> {
                    TimeMetric timeMetric = this.metricFactory.timer(SPOOL_PROCESSING);
                    try {
                        this.numActive.incrementAndGet();
                        this.processingActive.incrementAndGet();
                        Mail mail = queueItem.getMail();
                        LOGGER.debug("==== Begin processing mail {} ====", (Object)mail.getName());
                        try {
                            this.mailProcessor.service(mail);
                            queueItem.done(true);
                        }
                        catch (Exception e) {
                            if (this.active.get()) {
                                LOGGER.error("Exception processing mail while spooling", (Throwable)e);
                            }
                            queueItem.done(false);
                        }
                        finally {
                            LifecycleUtil.dispose((Object)mail);
                            mail = null;
                        }
                    }
                    catch (Throwable e) {
                        if (this.active.get()) {
                            LOGGER.error("Exception processing mail while spooling", e);
                        }
                    }
                    finally {
                        this.processingActive.decrementAndGet();
                        this.numActive.decrementAndGet();
                        timeMetric.stopAndPublish();
                    }
                });
            }
            catch (MailQueue.MailQueueException e1) {
                if (!this.active.get()) continue;
                LOGGER.error("Exception dequeue mail", (Throwable)e1);
            }
            catch (InterruptedException interruptedException) {}
        }
        LOGGER.info("Stop {} : {}", (Object)this.getClass().getName(), (Object)Thread.currentThread().getName());
    }

    @PreDestroy
    public void dispose() {
        LOGGER.info("{} dispose...", (Object)this.getClass().getName());
        this.active.set(false);
        this.dequeueService.shutdownNow();
        this.workerService.shutdown();
        long stop = System.currentTimeMillis() + 60000L;
        while (this.numActive.get() != 0 && stop > System.currentTimeMillis()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        LOGGER.info("{} thread shutdown completed.", (Object)this.getClass().getName());
    }

    public int getThreadCount() {
        return this.numThreads;
    }

    public int getCurrentSpoolCount() {
        return this.processingActive.get();
    }
}

