/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import java.io.IOException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowedMessageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowedMessageUtils.class);
    public static final char RFC2646_SPACE = ' ';
    public static final char RFC2646_QUOTE = '>';
    public static final String RFC2646_SIGNATURE = "-- ";
    public static final String RFC2646_CRLF = "\r\n";
    public static final String RFC2646_FROM = "From ";
    public static final int RFC2646_WIDTH = 78;

    private FlowedMessageUtils() {
    }

    public static String deflow(String text, boolean delSp) {
        String[] lines = text.split("\r\n|\n", -1);
        StringBuffer result = null;
        StringBuffer resultLine = new StringBuffer();
        int resultLineQuoteDepth = 0;
        boolean resultLineFlowed = false;
        for (int i = 0; i <= lines.length; ++i) {
            String line = i < lines.length ? lines[i] : null;
            int actualQuoteDepth = 0;
            if (line != null && line.length() > 0) {
                if (line.equals(RFC2646_SIGNATURE)) {
                    resultLineFlowed = false;
                } else if (line.charAt(0) == '>') {
                    for (actualQuoteDepth = 1; actualQuoteDepth < line.length() && line.charAt(actualQuoteDepth) == '>'; ++actualQuoteDepth) {
                    }
                    if (resultLineQuoteDepth != actualQuoteDepth) {
                        resultLineFlowed = false;
                    }
                    line = line.substring(actualQuoteDepth);
                } else if (resultLineQuoteDepth > 0) {
                    resultLineFlowed = false;
                }
                if (line.length() > 0 && line.charAt(0) == ' ') {
                    line = line.substring(1);
                }
            } else if (line == null) {
                resultLineFlowed = false;
            }
            if (!resultLineFlowed && i > 0) {
                if (resultLineQuoteDepth > 0) {
                    resultLine.insert(0, ' ');
                }
                for (int j = 0; j < resultLineQuoteDepth; ++j) {
                    resultLine.insert(0, '>');
                }
                if (result == null) {
                    result = new StringBuffer();
                } else {
                    result.append(RFC2646_CRLF);
                }
                result.append(resultLine.toString());
                resultLine = new StringBuffer();
                resultLineFlowed = false;
            }
            resultLineQuoteDepth = actualQuoteDepth;
            if (line == null) continue;
            if (!line.equals(RFC2646_SIGNATURE) && line.endsWith(" ") && i < lines.length - 1) {
                if (delSp) {
                    line = line.substring(0, line.length() - 1);
                }
                resultLineFlowed = true;
            } else {
                resultLineFlowed = false;
            }
            resultLine.append(line);
        }
        return result.toString();
    }

    public static String deflow(Message m) throws IOException, MessagingException {
        ContentType ct = new ContentType(m.getContentType());
        String format = ct.getParameter("format");
        if (ct.getBaseType().equals("text/plain") && format != null && format.equalsIgnoreCase("flowed")) {
            String delSp = ct.getParameter("delsp");
            return FlowedMessageUtils.deflow((String)m.getContent(), delSp != null && delSp.equalsIgnoreCase("yes"));
        }
        if (ct.getPrimaryType().equals("text")) {
            return (String)m.getContent();
        }
        return null;
    }

    public static void deflowMessage(Message m) throws MessagingException, IOException {
        ContentType ct = new ContentType(m.getContentType());
        String format = ct.getParameter("format");
        if (ct.getBaseType().equals("text/plain") && format != null && format.equalsIgnoreCase("flowed")) {
            String delSp = ct.getParameter("delsp");
            String deflowed = FlowedMessageUtils.deflow((String)m.getContent(), delSp != null && delSp.equalsIgnoreCase("yes"));
            ct.getParameterList().remove("format");
            ct.getParameterList().remove("delsp");
            if (ct.toString().contains("flowed")) {
                LOGGER.error("FlowedMessageUtils dind't remove the flowed correctly");
            }
            m.setContent((Object)deflowed, ct.toString());
            m.saveChanges();
        }
    }

    public static String flow(String text, boolean delSp) {
        return FlowedMessageUtils.flow(text, delSp, 78);
    }

    public static String flow(String text, boolean delSp, int width) {
        StringBuilder result = new StringBuilder();
        String[] lines = text.split("\r\n|\n", -1);
        for (int i = 0; i < lines.length; ++i) {
            int quoteDepth;
            String line = lines[i];
            boolean notempty = line.length() > 0;
            for (quoteDepth = 0; quoteDepth < line.length() && line.charAt(quoteDepth) == '>'; ++quoteDepth) {
            }
            if (quoteDepth > 0) {
                line = quoteDepth + 1 < line.length() && line.charAt(quoteDepth) == ' ' ? line.substring(quoteDepth + 1) : line.substring(quoteDepth);
            }
            while (notempty) {
                int j;
                int extra = 0;
                if (quoteDepth == 0) {
                    if (line.startsWith(" ") || line.startsWith(">") || line.startsWith(RFC2646_FROM)) {
                        line = " " + line;
                        extra = 1;
                    }
                } else {
                    line = ' ' + line;
                    for (j = 0; j < quoteDepth; ++j) {
                        line = ">" + line;
                    }
                    extra = quoteDepth + 1;
                }
                if ((j = width - 1) >= line.length()) {
                    j = line.length() - 1;
                } else {
                    while (j >= extra && (delSp && FlowedMessageUtils.isAlphaChar(text, j) || !delSp && line.charAt(j) != ' ')) {
                        --j;
                    }
                    if (j < extra) {
                        for (j = width - 1; j < line.length() - 1 && (delSp && FlowedMessageUtils.isAlphaChar(text, j) || !delSp && line.charAt(j) != ' '); ++j) {
                        }
                    }
                }
                result.append(line.substring(0, j + 1));
                if (j < line.length() - 1) {
                    if (delSp) {
                        result.append(' ');
                    }
                    result.append(RFC2646_CRLF);
                }
                notempty = (line = line.substring(j + 1)).length() > 0;
            }
            if (i >= lines.length - 1) continue;
            while (result.length() > 0 && result.charAt(result.length() - 1) == ' ') {
                result.deleteCharAt(result.length() - 1);
            }
            result.append(RFC2646_CRLF);
        }
        return result.toString();
    }

    public static void setFlowedContent(Message m, String text, boolean delSp) throws MessagingException {
        FlowedMessageUtils.setFlowedContent(m, text, delSp, 78, true, null);
    }

    public static void setFlowedContent(Message m, String text, boolean delSp, int width, boolean preserveCharset, String charset) throws MessagingException {
        ContentType ct;
        String coded = FlowedMessageUtils.flow(text, delSp, width);
        if (preserveCharset) {
            ct = new ContentType(m.getContentType());
            charset = ct.getParameter("charset");
        }
        ct = new ContentType();
        ct.setPrimaryType("text");
        ct.setSubType("plain");
        if (charset != null) {
            ct.setParameter("charset", charset);
        }
        ct.setParameter("format", "flowed");
        if (delSp) {
            ct.setParameter("delsp", "yes");
        }
        m.setContent((Object)coded, ct.toString());
        m.saveChanges();
    }

    public static void flowMessage(Message m, boolean delSp) throws MessagingException, IOException {
        FlowedMessageUtils.flowMessage(m, delSp, 78);
    }

    public static void flowMessage(Message m, boolean delSp, int width) throws MessagingException, IOException {
        ContentType ct = new ContentType(m.getContentType());
        if (!ct.getBaseType().equals("text/plain")) {
            return;
        }
        String format = ct.getParameter("format");
        String text = format != null && format.equals("flowed") ? FlowedMessageUtils.deflow(m) : (String)m.getContent();
        String coded = FlowedMessageUtils.flow(text, delSp, width);
        ct.setParameter("format", "flowed");
        if (delSp) {
            ct.setParameter("delsp", "yes");
        }
        m.setContent((Object)coded, ct.toString());
        m.saveChanges();
    }

    public static boolean isAlphaChar(String text, int index) {
        char c = text.charAt(index);
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    public static boolean isFlowedTextMessage(Message m) throws MessagingException {
        ContentType ct = new ContentType(m.getContentType());
        String format = ct.getParameter("format");
        return ct.getBaseType().equals("text/plain") && format != null && format.equalsIgnoreCase("flowed");
    }
}

