/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.mailet.Mail;
import org.apache.mailet.base.AutomaticallySentMailDetector;

public class AutomaticallySentMailDetectorImpl
implements AutomaticallySentMailDetector {
    private static final String[] MAILING_LIST_HEADERS = new String[]{"List-Help", "List-Subscribe", "List-Unsubscribe", "List-Owner", "List-Post", "List-Id", "List-Archive"};

    @Override
    public boolean isAutomaticallySent(Mail mail) throws MessagingException {
        return mail.getSender() == null || this.isMailingList(mail) || this.isAutoSubmitted(mail) || this.isMdnSentAutomatically(mail);
    }

    @Override
    public boolean isMailingList(Mail mail) throws MessagingException {
        return this.senderIsMailingList(mail) || this.headerIsMailingList(mail);
    }

    private boolean senderIsMailingList(Mail mail) {
        MailAddress sender = mail.getSender();
        if (sender == null) {
            return false;
        }
        String localPart = sender.getLocalPart();
        return localPart.startsWith("owner-") || localPart.endsWith("-request") || localPart.equalsIgnoreCase("MAILER-DAEMON") || localPart.equalsIgnoreCase("LISTSERV") || localPart.equalsIgnoreCase("majordomo");
    }

    private boolean headerIsMailingList(Mail mail) throws MessagingException {
        return mail.getMessage().getMatchingHeaders(MAILING_LIST_HEADERS).hasMoreElements();
    }

    @Override
    public boolean isAutoSubmitted(Mail mail) throws MessagingException {
        String[] headers = mail.getMessage().getHeader("Auto-Submitted");
        if (headers != null) {
            return Arrays.stream(headers).anyMatch(header -> header.equalsIgnoreCase("auto-replied"));
        }
        return false;
    }

    @Override
    public boolean isMdnSentAutomatically(Mail mail) throws MessagingException {
        ResultCollector resultCollector = new ResultCollector(false);
        MimeStreamParser parser = new MimeStreamParser(MimeConfig.PERMISSIVE);
        parser.setContentHandler((ContentHandler)this.createMdnContentHandler(resultCollector));
        try {
            parser.parse(mail.getMessage().getInputStream());
        }
        catch (MimeException e) {
            throw new MessagingException("Can not parse Mime", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MessagingException("Can not read content", (Exception)e);
        }
        return resultCollector.getResult();
    }

    private AbstractContentHandler createMdnContentHandler(final ResultCollector resultCollector) {
        return new AbstractContentHandler(){

            public void body(BodyDescriptor bodyDescriptor, InputStream inputStream) throws MimeException, IOException {
                if (bodyDescriptor.getMimeType().equalsIgnoreCase("message/disposition-notification")) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith("Disposition:") || !line.contains("MDN-sent-automatically") && !line.contains("automatic-action")) continue;
                        resultCollector.setResult(true);
                    }
                }
            }
        };
    }

    private static class ResultCollector {
        private boolean result;

        public ResultCollector(boolean result) {
            this.result = result;
        }

        public boolean getResult() {
            return this.result;
        }

        public void setResult(boolean result) {
            this.result = result;
        }
    }
}

