/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.util;

import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.redirect.SpecialAddress;
import org.apache.mailet.Mail;

public class ReplyToUtils {
    private final Optional<MailAddress> replyTo;

    public static ReplyToUtils from(Optional<MailAddress> replyTo) {
        return new ReplyToUtils(replyTo);
    }

    public static ReplyToUtils from(MailAddress replyTo) {
        return new ReplyToUtils(Optional.ofNullable(replyTo));
    }

    private ReplyToUtils(Optional<MailAddress> replyTo) {
        this.replyTo = replyTo;
    }

    public Optional<MailAddress> getReplyTo(Mail originalMail) throws MessagingException {
        if (this.replyTo.isPresent()) {
            if (this.replyTo.get().equals((Object)SpecialAddress.UNALTERED)) {
                return Optional.empty();
            }
            return Optional.ofNullable(originalMail.getSender());
        }
        return Optional.empty();
    }
}

