/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers.dlp;

import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.transport.matchers.dlp.DlpDomainRules;

public interface DlpRulesLoader {
    public DlpDomainRules load(Domain var1);

    public static class Impl
    implements DlpRulesLoader {
        private final DLPConfigurationStore configurationStore;

        @Inject
        public Impl(DLPConfigurationStore configurationStore) {
            this.configurationStore = configurationStore;
        }

        @Override
        public DlpDomainRules load(Domain domain) {
            return this.toRules(this.configurationStore.list(domain));
        }

        private DlpDomainRules toRules(Stream<DLPConfigurationItem> items) {
            DlpDomainRules.DlpDomainRulesBuilder builder = DlpDomainRules.builder();
            items.forEach(item -> item.getTargets().list().forEach(type -> builder.rule((DLPConfigurationItem.Targets.Type)type, item.getId(), item.getRegexp())));
            return builder.build();
        }
    }
}

