/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers.dlp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.transport.matchers.dlp.DlpRulesLoader;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class Dlp
extends GenericMatcher {
    public static final String DLP_MATCHED_RULE = "DlpMatchedRule";
    private final DlpRulesLoader rulesLoader;

    @VisibleForTesting
    Dlp(DlpRulesLoader rulesLoader) {
        this.rulesLoader = rulesLoader;
    }

    @Inject
    public Dlp(DLPConfigurationStore configurationStore) {
        this(new DlpRulesLoader.Impl(configurationStore));
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        Optional<DLPConfigurationItem.Id> firstMatchingRuleId = this.findFirstMatchingRule(mail);
        if (firstMatchingRuleId.isPresent()) {
            DLPConfigurationItem.Id ruleId = firstMatchingRuleId.get();
            this.setRuleIdAsMailAttribute(mail, ruleId);
            return mail.getRecipients();
        }
        return ImmutableList.of();
    }

    private void setRuleIdAsMailAttribute(Mail mail, DLPConfigurationItem.Id ruleId) {
        mail.setAttribute(DLP_MATCHED_RULE, (Serializable)((Object)ruleId.asString()));
    }

    private Optional<DLPConfigurationItem.Id> findFirstMatchingRule(Mail mail) {
        return Optional.ofNullable(mail.getSender()).flatMap(sender -> this.matchingRule((MailAddress)sender, mail));
    }

    private Optional<DLPConfigurationItem.Id> matchingRule(MailAddress address, Mail mail) {
        return this.rulesLoader.load(address.getDomain()).match(mail);
    }

    public String getMatcherInfo() {
        return "Data Leak Prevention Matcher";
    }
}

