/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.matchers.AbstractNetworkMatcher;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class SenderInFakeDomain
extends AbstractNetworkMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SenderInFakeDomain.class);

    public Collection<MailAddress> match(Mail mail) {
        if (mail.getSender() == null) {
            return null;
        }
        Domain domain = mail.getSender().getDomain();
        Collection servers = this.getMailetContext().getMailServers(domain);
        if (servers.size() == 0) {
            LOGGER.info("No MX, A, or CNAME record found for domain: {}", (Object)domain);
            return mail.getRecipients();
        }
        if (this.matchNetwork((String)servers.iterator().next())) {
            LOGGER.info("Banned IP found for domain: {}", (Object)domain);
            LOGGER.info(" --> :{}", servers.iterator().next());
            return mail.getRecipients();
        }
        return null;
    }
}

