/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.ArrayList;
import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public abstract class AbstractQuotaMatcher
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQuotaMatcher.class);

    public final Collection<MailAddress> match(Mail mail) throws MessagingException {
        ArrayList<MailAddress> matching = null;
        if (this.isSenderChecked(mail.getSender())) {
            matching = new ArrayList<MailAddress>();
            for (MailAddress recipient : mail.getRecipients()) {
                if (!this.isRecipientChecked(recipient) || !this.isOverQuota(recipient, mail)) continue;
                matching.add(recipient);
            }
        }
        return matching;
    }

    protected boolean isOverQuota(MailAddress address, Mail mail) {
        try {
            boolean over;
            boolean bl = over = this.getQuota(address, mail) < this.getUsed(address, mail);
            if (over) {
                LOGGER.info("{} is over quota.", (Object)address);
            }
            return over;
        }
        catch (Throwable e) {
            LOGGER.error("Exception checking quota for: {}", (Object)address, (Object)e);
            return false;
        }
    }

    protected boolean isSenderChecked(MailAddress sender) throws MessagingException {
        return sender != null && !this.getMailetContext().getPostmaster().equals((Object)sender);
    }

    protected boolean isRecipientChecked(MailAddress recipient) throws MessagingException {
        return !this.getMailetContext().getPostmaster().equals((Object)recipient);
    }

    protected abstract long getQuota(MailAddress var1, Mail var2) throws MessagingException;

    protected abstract long getUsed(MailAddress var1, Mail var2) throws MessagingException;

    protected long parseQuota(String amount) throws MessagingException {
        try {
            long quota;
            if (amount.endsWith("k")) {
                amount = amount.substring(0, amount.length() - 1);
                quota = Long.parseLong(amount) * 1024L;
            } else if (amount.endsWith("m")) {
                amount = amount.substring(0, amount.length() - 1);
                quota = Long.parseLong(amount) * 1024L * 1024L;
            } else {
                quota = Long.parseLong(amount);
            }
            return quota;
        }
        catch (Exception e) {
            throw new MessagingException("Exception parsing quota", e);
        }
    }
}

