/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import java.io.IOException;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.james.javax.MultipartUtil;
import org.apache.mailet.MailetContext;

public class Converter7Bit {
    private final MailetContext mailetContext;

    public Converter7Bit(MailetContext mailetContext) {
        this.mailetContext = mailetContext;
    }

    public MimePart convertTo7Bit(MimePart part) throws MessagingException, IOException {
        if (part.isMimeType("multipart/*")) {
            List bodyParts = MultipartUtil.retrieveBodyParts((Multipart)((MimeMultipart)part.getContent()));
            for (BodyPart bodyPart : bodyParts) {
                this.convertTo7Bit((MimePart)bodyPart);
            }
        } else if ("8bit".equals(part.getEncoding())) {
            String contentTransferEncoding = part.isMimeType("text/*") ? "quoted-printable" : "base64";
            part.setContent(part.getContent(), part.getContentType());
            part.setHeader("Content-Transfer-Encoding", contentTransferEncoding);
            part.addHeader("X-MIME-Autoconverted", "from 8bit to " + contentTransferEncoding + " by " + this.mailetContext.getServerInfo());
        }
        return part;
    }
}

