/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.ParseException;
import org.apache.james.mime4j.field.address.DefaultAddressParser;
import org.apache.james.mime4j.utils.search.MessageMatcher;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.james.transport.mailets.jsieve.ActionDispatcher;
import org.apache.james.transport.mailets.jsieve.Poster;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.exception.InternetAddressException;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.AddressImpl;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.mail.MailUtils;
import org.apache.jsieve.mail.SieveMailException;
import org.apache.jsieve.mail.optional.EnvelopeAccessors;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SieveMailAdapter
implements MailAdapter,
EnvelopeAccessors,
ActionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SieveMailAdapter.class);
    private Mail fieldMail;
    private MailetContext fieldMailetContext;
    private List<Action> fieldActions;
    private final ActionDispatcher dispatcher;
    private final Poster poster;
    private final DateTime scriptActivationDate;
    private final DateTime scriptInterpretationDate;
    private final MailAddress recipient;

    public SieveMailAdapter(Mail aMail, MailetContext aMailetContext, ActionDispatcher dispatcher, Poster poster, DateTime scriptActivationDate, DateTime scriptInterpretationDate, MailAddress recipient) {
        this.poster = poster;
        this.dispatcher = dispatcher;
        this.scriptInterpretationDate = scriptInterpretationDate;
        this.scriptActivationDate = scriptActivationDate;
        this.recipient = recipient;
        this.setMail(aMail);
        this.setMailetContext(aMailetContext);
    }

    @Override
    public DateTime getScriptActivationDate() {
        return this.scriptActivationDate;
    }

    @Override
    public DateTime getScriptInterpretationDate() {
        return this.scriptInterpretationDate;
    }

    @Override
    public MailAddress getRecipient() {
        return this.recipient;
    }

    protected MimeMessage getMessage() throws MessagingException {
        return this.getMail().getMessage();
    }

    public List<Action> getActions() {
        List<Action> actions = null;
        actions = this.getActionsBasic();
        if (null == actions) {
            this.updateActions();
            return this.getActions();
        }
        return actions;
    }

    protected List<Action> computeActions() {
        return new ArrayList<Action>();
    }

    private List<Action> getActionsBasic() {
        return this.fieldActions;
    }

    public void addAction(Action action) {
        this.getActions().add(action);
    }

    public void executeActions() throws SieveException {
        List<Action> actions = this.getActions();
        for (Action action : actions) {
            LOGGER.info("Executing action: {}", (Object)action);
            try {
                this.dispatcher.execute(action, this.getMail(), this);
            }
            catch (MessagingException e) {
                throw new SieveException((Throwable)e);
            }
        }
    }

    protected void setActions(List<Action> actions) {
        this.fieldActions = actions;
    }

    protected void updateActions() {
        this.setActions(this.computeActions());
    }

    public List<String> getHeader(String name) throws SieveMailException {
        try {
            String[] headers = this.getMessage().getHeader(name);
            return headers == null ? new ArrayList(0) : Arrays.asList(headers);
        }
        catch (MessagingException ex) {
            throw new SieveMailException((Throwable)ex);
        }
    }

    public List<String> getHeaderNames() throws SieveMailException {
        HashSet<String> headerNames = new HashSet<String>();
        try {
            Enumeration allHeaders = this.getMessage().getAllHeaders();
            while (allHeaders.hasMoreElements()) {
                headerNames.add(((Header)allHeaders.nextElement()).getName());
            }
            return new ArrayList<String>(headerNames);
        }
        catch (MessagingException ex) {
            throw new SieveMailException((Throwable)ex);
        }
    }

    public List<String> getMatchingHeader(String name) throws SieveMailException {
        return MailUtils.getMatchingHeader((MailAdapter)this, (String)name);
    }

    public int getSize() throws SieveMailException {
        try {
            return (int)this.getMail().getMessageSize();
        }
        catch (MessagingException ex) {
            throw new SieveMailException((Throwable)ex);
        }
    }

    protected Map<String, String> getEnvelopes() {
        HashMap<String, String> envelopes = new HashMap<String, String>(2);
        if (null != this.getEnvelopeFrom()) {
            envelopes.put("From", this.getEnvelopeFrom());
        }
        if (null != this.getEnvelopeTo()) {
            envelopes.put("To", this.getEnvelopeTo());
        }
        return envelopes;
    }

    public List<String> getEnvelope(String name) throws SieveMailException {
        ArrayList<String> values = new ArrayList<String>(1);
        String value = this.getEnvelopes().get(name);
        if (null != value) {
            values.add(value);
        }
        return values;
    }

    public List<String> getEnvelopeNames() throws SieveMailException {
        return new ArrayList<String>(this.getEnvelopes().keySet());
    }

    public List<String> getMatchingEnvelope(String name) throws SieveMailException {
        ArrayList<String> matchedEnvelopeValues = new ArrayList<String>(32);
        for (String envelopeName : this.getEnvelopeNames()) {
            if (!envelopeName.trim().equalsIgnoreCase(name)) continue;
            matchedEnvelopeValues.addAll(this.getEnvelope(envelopeName));
        }
        return matchedEnvelopeValues;
    }

    public String getEnvelopeFrom() {
        MailAddress sender = this.getMail().getSender();
        return null == sender ? "" : sender.toString();
    }

    public String getEnvelopeTo() {
        return this.getMail().getRecipients().stream().map(mailAddress -> mailAddress.toInternetAddress().getAddress()).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Mail getMail() {
        return this.fieldMail;
    }

    protected void setMail(Mail mail) {
        this.fieldMail = mail;
    }

    public MailetContext getMailetContext() {
        return this.fieldMailetContext;
    }

    protected void setMailetContext(MailetContext mailetContext) {
        this.fieldMailetContext = mailetContext;
    }

    public String toString() {
        String messageID = null;
        try {
            messageID = this.getMail().getMessage().getMessageID();
        }
        catch (MessagingException e) {
            messageID = "<" + e.getMessage() + ">";
        }
        return this.getClass().getName() + " Envelope From: " + (null == this.getEnvelopeFrom() ? "null" : this.getEnvelopeFrom()) + " Envelope To: " + (null == this.getEnvelopeTo() ? "null" : this.getEnvelopeTo()) + " Message ID: " + (null == messageID ? "null" : messageID);
    }

    public String getContentType() throws SieveMailException {
        try {
            return this.getMessage().getContentType();
        }
        catch (MessagingException e) {
            throw new SieveMailException((Throwable)e);
        }
    }

    public MailAdapter.Address[] parseAddresses(String arg) throws SieveMailException, InternetAddressException {
        try {
            List<String> headerValues = this.getHeader(arg);
            ArrayList<MailboxList> mailboxes = new ArrayList<MailboxList>();
            int size = 0;
            for (String headerValue : headerValues) {
                MailboxList mailboxList = new AddressList((List)DefaultAddressParser.DEFAULT.parseAddressList((CharSequence)headerValue), true).flatten();
                size += mailboxList.size();
                mailboxes.add(mailboxList);
            }
            int i = 0;
            MailAdapter.Address[] results = new MailAdapter.Address[size];
            for (MailboxList mailboxList : mailboxes) {
                for (Mailbox mailbox : mailboxList) {
                    results[i] = new AddressImpl(mailbox.getLocalPart(), mailbox.getDomain());
                    ++i;
                }
            }
            return results;
        }
        catch (ParseException e) {
            throw new InternetAddressException((Throwable)e);
        }
    }

    @Override
    public String getServerInfo() {
        return this.getMailetContext().getServerInfo();
    }

    @Override
    public void post(String uri, Mail mail) throws MessagingException {
        this.poster.post(uri, mail);
    }

    @Override
    public void post(MailAddress sender, Collection<MailAddress> recipients, MimeMessage mail) throws MessagingException {
        this.getMailetContext().sendMail(sender, recipients, mail);
    }

    public boolean isInBodyText(List<String> phrasesCaseInsensitive) throws SieveMailException {
        try {
            return MessageMatcher.builder().contentTypes((List)Lists.newArrayList((Object[])new String[]{"text/plain"})).includeHeaders(false).caseInsensitive(false).searchContents(Lists.transform(phrasesCaseInsensitive, s -> s)).build().messageMatches(this.getMail().getMessage().getInputStream());
        }
        catch (Exception e) {
            throw new SieveMailException("Error searching in the mail content", (Throwable)e);
        }
    }

    public boolean isInBodyRaw(List<String> phrasesCaseInsensitive) throws SieveMailException {
        try {
            return MessageMatcher.builder().includeHeaders(false).caseInsensitive(false).ignoringMime(true).searchContents(Lists.transform(phrasesCaseInsensitive, s -> s)).build().messageMatches(this.getMail().getMessage().getInputStream());
        }
        catch (Exception e) {
            throw new SieveMailException("Error searching in the mail content", (Throwable)e);
        }
    }

    public boolean isInBodyContent(List<String> contentTypes, List<String> phrasesCaseInsensitive) throws SieveMailException {
        try {
            return MessageMatcher.builder().contentTypes(contentTypes).includeHeaders(false).caseInsensitive(false).searchContents(Lists.transform(phrasesCaseInsensitive, s -> s)).build().messageMatches(this.getMail().getMessage().getInputStream());
        }
        catch (Exception e) {
            throw new SieveMailException("Error searching in the mail content", (Throwable)e);
        }
    }

    public void setContext(SieveContext context) {
    }
}

