/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.consumers.ThrowingConsumer;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToSenderDomainRepository
extends GenericMailet {
    public static final String URL_PREFIX = "urlPrefix";
    public static final String PASS_THROUGH = "passThrough";
    public static final String ALLOW_REPOSITORY_CREATION = "allowRepositoryCreation";
    private static final Logger LOGGER = LoggerFactory.getLogger(ToSenderDomainRepository.class);
    private static final boolean DEFAULT_CONSUME = false;
    private static final boolean DEFAULT_ALLOW_REPOSITORY_CREATION = true;
    private final MailRepositoryStore mailRepositoryStore;
    private String urlPrefix;
    private boolean passThrough;
    private boolean allowRepositoryCreation;

    @Inject
    public ToSenderDomainRepository(MailRepositoryStore mailRepositoryStore) {
        this.mailRepositoryStore = mailRepositoryStore;
    }

    public void init() throws MessagingException {
        this.urlPrefix = Optional.ofNullable(this.getInitParameter(URL_PREFIX)).orElseThrow(() -> new MessagingException("'urlPrefix' is a mandatory configuration property"));
        this.passThrough = this.getInitParameter(PASS_THROUGH, false);
        this.allowRepositoryCreation = this.getInitParameter(ALLOW_REPOSITORY_CREATION, true);
    }

    public void service(Mail mail) throws MessagingException {
        MailRepositoryUrl repositoryUrl = MailRepositoryUrl.from((String)(this.urlPrefix + mail.getSender().getDomain().asString()));
        this.store(mail, repositoryUrl);
        if (!this.passThrough) {
            mail.setState("ghost");
        }
    }

    private void store(Mail mail, MailRepositoryUrl url) throws MessagingException {
        try {
            Optional<MailRepository> mailRepository = this.retrieveRepository(url);
            if (!mailRepository.isPresent()) {
                LOGGER.warn("'{}' mail repository does not exist and will not be created. Mail {} will not be stored in it.", (Object)url, (Object)mail.getName());
            }
            ThrowingConsumer storingConsumer = repository -> repository.store(mail);
            mailRepository.ifPresent(Throwing.consumer((ThrowingConsumer)storingConsumer).sneakyThrow());
        }
        catch (MailRepositoryStore.MailRepositoryStoreException e) {
            throw new MessagingException("Error while selecting url " + url, (Exception)((Object)e));
        }
    }

    private Optional<MailRepository> retrieveRepository(MailRepositoryUrl url) throws MailRepositoryStore.MailRepositoryStoreException {
        if (this.allowRepositoryCreation) {
            return Optional.of(this.mailRepositoryStore.select(url));
        }
        return this.mailRepositoryStore.get(url);
    }

    public String getMailetInfo() {
        return "ToSenderDomainRepository Mailet";
    }
}

