/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.james.core.MailAddress;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.javax.MimeMultipartReport;
import org.apache.james.server.core.MailImpl;
import org.apache.james.transport.mailets.managesieve.ManageSieveMailet;
import org.apache.james.transport.mailets.redirect.InitParameters;
import org.apache.james.transport.mailets.redirect.MailModifier;
import org.apache.james.transport.mailets.redirect.NotifyMailetInitParameters;
import org.apache.james.transport.mailets.redirect.NotifyMailetsMessage;
import org.apache.james.transport.mailets.redirect.RedirectNotify;
import org.apache.james.transport.mailets.redirect.SpecialAddress;
import org.apache.james.transport.mailets.redirect.TypeCode;
import org.apache.james.transport.mailets.utils.MimeMessageModifier;
import org.apache.james.transport.mailets.utils.MimeMessageUtils;
import org.apache.james.transport.util.Patterns;
import org.apache.james.transport.util.RecipientsUtils;
import org.apache.james.transport.util.ReplyToUtils;
import org.apache.james.transport.util.SenderUtils;
import org.apache.james.transport.util.SpecialAddressesUtils;
import org.apache.james.transport.util.TosUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.DateFormats;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSNBounce
extends GenericMailet
implements RedirectNotify {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageSieveMailet.class);
    private static final String[] CONFIGURABLE_PARAMETERS = new String[]{"debug", "passThrough", "messageString", "attachment", "sender", "prefix"};
    private static final List<MailAddress> RECIPIENT_MAIL_ADDRESSES = ImmutableList.of((Object)SpecialAddress.REVERSE_PATH);
    private static final List<InternetAddress> TO_INTERNET_ADDRESSES = ImmutableList.of((Object)SpecialAddress.REVERSE_PATH.toInternetAddress());
    private static final String LOCALHOST = "127.0.0.1";
    private static final Pattern DIAG_PATTERN = Patterns.compilePatternUncheckedException("^\\d{3}\\s.*$");
    private static final String MACHINE_PATTERN = "[machine]";
    private static final String LINE_BREAK = "\n";
    private final DNSService dns;
    private final FastDateFormat dateFormatter;
    private String messageString = null;

    @Inject
    public DSNBounce(DNSService dns) {
        this(dns, DateFormats.RFC822_DATE_FORMAT);
    }

    public DSNBounce(DNSService dns, FastDateFormat dateFormatter) {
        this.dns = dns;
        this.dateFormatter = dateFormatter;
    }

    public void init() throws MessagingException {
        if (this.getInitParameters().isDebug()) {
            LOGGER.debug("Initializing");
        }
        this.checkInitParameters(this.getAllowedInitParameters());
        if (this.getInitParameters().isStatic() && this.getInitParameters().isDebug()) {
            LOGGER.debug(this.getInitParameters().asString());
        }
        this.messageString = this.getInitParameter("messageString", "Hi. This is the James mail server at [machine].\nI'm afraid I wasn't able to deliver your message to the following addresses.\nThis is a permanent error; I've given up. Sorry it didn't work out.  Below\nI include the list of recipients and the reason why I was unable to deliver\nyour message.\n");
    }

    public String getMailetInfo() {
        return "DSNBounce Mailet";
    }

    @Override
    public InitParameters getInitParameters() {
        return NotifyMailetInitParameters.from(this);
    }

    @Override
    public String[] getAllowedInitParameters() {
        return CONFIGURABLE_PARAMETERS;
    }

    @Override
    public DNSService getDNSService() {
        return this.dns;
    }

    @Override
    public String getMessage(Mail originalMail) throws MessagingException {
        return new NotifyMailetsMessage().generateMessage(this.getInitParameters().getMessage(), originalMail);
    }

    @Override
    public List<MailAddress> getRecipients() {
        return RECIPIENT_MAIL_ADDRESSES;
    }

    @Override
    public List<MailAddress> getRecipients(Mail originalMail) throws MessagingException {
        return RecipientsUtils.from(this).getRecipients(originalMail);
    }

    @Override
    public List<InternetAddress> getTo() {
        return TO_INTERNET_ADDRESSES;
    }

    @Override
    public List<MailAddress> getTo(Mail originalMail) throws MessagingException {
        return TosUtils.from(this).getTo(originalMail);
    }

    @Override
    public Optional<MailAddress> getReplyTo() throws MessagingException {
        return Optional.of(SpecialAddress.NULL);
    }

    @Override
    public Optional<MailAddress> getReplyTo(Mail originalMail) throws MessagingException {
        return ReplyToUtils.from(this.getReplyTo()).getReplyTo(originalMail);
    }

    @Override
    public Optional<MailAddress> getReversePath() throws MessagingException {
        return SpecialAddressesUtils.from(this).getFirstSpecialAddressIfMatchingOrGivenAddress(this.getInitParameters().getReversePath(), RedirectNotify.REVERSE_PATH_ALLOWED_SPECIALS);
    }

    @Override
    public Optional<MailAddress> getReversePath(Mail originalMail) {
        return Optional.of(SpecialAddress.NULL);
    }

    @Override
    public Optional<MailAddress> getSender() throws MessagingException {
        return SpecialAddressesUtils.from(this).getFirstSpecialAddressIfMatchingOrGivenAddress(this.getInitParameters().getSender(), RedirectNotify.SENDER_ALLOWED_SPECIALS);
    }

    @Override
    public Optional<MailAddress> getSender(Mail originalMail) throws MessagingException {
        return SenderUtils.from(this.getSender()).getSender(originalMail);
    }

    @Override
    public Optional<String> getSubjectPrefix(Mail newMail, String subjectPrefix, Mail originalMail) throws MessagingException {
        return new MimeMessageUtils(originalMail.getMessage()).subjectWithPrefix(subjectPrefix);
    }

    @Override
    public void service(Mail originalMail) throws MessagingException {
        if (this.hasSender(originalMail)) {
            this.trySendBounce(originalMail);
        }
        if (!this.getInitParameters().getPassThrough()) {
            originalMail.setState("ghost");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySendBounce(Mail originalMail) throws MessagingException {
        MailImpl newMail = MailImpl.duplicate((Mail)originalMail);
        try {
            newMail.setRemoteHost(this.getRemoteHost());
            newMail.setRemoteAddr(this.getRemoteAddr());
            newMail.setRecipients(this.getSenderAsList(originalMail));
            if (this.getInitParameters().isDebug()) {
                LOGGER.debug("New mail - sender: {}, recipients: {}, name: {}, remoteHost: {}, remoteAddr: {}, state: {}, lastUpdated: {}, errorMessage: {}", new Object[]{newMail.getSender(), newMail.getRecipients(), newMail.getName(), newMail.getRemoteHost(), newMail.getRemoteAddr(), newMail.getState(), newMail.getLastUpdated(), newMail.getErrorMessage()});
            }
            newMail.setMessage(this.createBounceMessage(originalMail));
            MailModifier mailModifier = MailModifier.builder().mailet(this).mail(newMail).dns(this.dns).build();
            mailModifier.setRecipients(this.getRecipients(originalMail));
            mailModifier.setTo(this.getTo(originalMail));
            mailModifier.setSubjectPrefix(originalMail);
            mailModifier.setReplyTo(this.getReplyTo(originalMail));
            mailModifier.setReversePath(this.getReversePath(originalMail));
            mailModifier.setIsReply(this.getInitParameters().isReply(), originalMail);
            mailModifier.setSender(this.getSender(originalMail));
            newMail.getMessage().setHeader("Date", this.getDateHeader(originalMail));
            newMail.getMessage().saveChanges();
            this.getMailetContext().sendMail((Mail)newMail);
        }
        finally {
            newMail.dispose();
        }
    }

    private boolean hasSender(Mail originalMail) {
        if (originalMail.getSender() == null) {
            if (this.getInitParameters().isDebug()) {
                LOGGER.info("Processing a bounce request for a message with an empty reverse-path.  No bounce will be sent.");
            }
            return false;
        }
        return true;
    }

    private String getDateHeader(Mail originalMail) throws MessagingException {
        String[] date = originalMail.getMessage().getHeader("Date");
        if (date == null) {
            return this.dateFormatter.format(new Date());
        }
        return date[0];
    }

    private String getRemoteHost() {
        try {
            return this.dns.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    private String getRemoteAddr() {
        try {
            return this.dns.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return LOCALHOST;
        }
    }

    private List<MailAddress> getSenderAsList(Mail originalMail) {
        MailAddress reversePath = originalMail.getSender();
        if (this.getInitParameters().isDebug()) {
            LOGGER.debug("Processing a bounce request for a message with a reverse path.  The bounce will be sent to {}", (Object)reversePath);
        }
        return ImmutableList.of((Object)reversePath);
    }

    private MimeMessage createBounceMessage(Mail originalMail) throws MessagingException {
        MimeMultipartReport multipart = this.createMultipart(originalMail);
        MimeMessage newMessage = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties(), null));
        newMessage.setContent((Multipart)multipart);
        newMessage.setHeader("Content-Type", multipart.getContentType());
        return newMessage;
    }

    private MimeMultipartReport createMultipart(Mail originalMail) throws MessagingException {
        MimeMultipartReport multipart = new MimeMultipartReport();
        multipart.setReportType("delivery-status");
        multipart.addBodyPart((BodyPart)this.createTextMsg(originalMail));
        multipart.addBodyPart((BodyPart)this.createDSN(originalMail));
        if (!this.getInitParameters().getAttachmentType().equals((Object)TypeCode.NONE)) {
            multipart.addBodyPart((BodyPart)this.createAttachedOriginal(originalMail, this.getInitParameters().getAttachmentType()));
        }
        return multipart;
    }

    private MimeBodyPart createTextMsg(Mail originalMail) throws MessagingException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.bounceMessage()).append(LINE_BREAK);
        buffer.append("Failed recipient(s):").append(LINE_BREAK);
        for (MailAddress mailAddress : originalMail.getRecipients()) {
            buffer.append(mailAddress);
        }
        buffer.append(LINE_BREAK).append(LINE_BREAK);
        buffer.append("Error message:").append(LINE_BREAK);
        buffer.append((String)((Object)originalMail.getAttribute("delivery-error"))).append(LINE_BREAK);
        buffer.append(LINE_BREAK);
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setText(buffer.toString());
        return bodyPart;
    }

    private String getHostname() {
        try {
            InetAddress hostAddress = InetAddress.getLocalHost();
            return hostAddress.getHostName();
        }
        catch (Exception e) {
            return "[address unknown]";
        }
    }

    private String bounceMessage() {
        if (this.messageString.contains(MACHINE_PATTERN)) {
            return this.messageString.replace(MACHINE_PATTERN, this.getHostname());
        }
        return this.messageString;
    }

    private MimeBodyPart createDSN(Mail originalMail) throws MessagingException {
        StringBuffer buffer = new StringBuffer();
        this.appendReportingMTA(buffer);
        buffer.append("Received-From-MTA: dns; " + originalMail.getRemoteHost()).append(LINE_BREAK);
        for (MailAddress rec : originalMail.getRecipients()) {
            this.appendRecipient(buffer, rec, this.getDeliveryError(originalMail), originalMail.getLastUpdated());
        }
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Object)buffer.toString(), "text/plain");
        bodyPart.setHeader("Content-Type", "message/delivery-status");
        bodyPart.setDescription("Delivery Status Notification");
        bodyPart.setFileName("status.dat");
        return bodyPart;
    }

    private void appendReportingMTA(StringBuffer buffer) {
        try {
            buffer.append("Reporting-MTA: dns; " + this.dns.getHostName(this.dns.getLocalHost())).append(LINE_BREAK);
        }
        catch (Exception e) {
            LOGGER.error("Sending DSN without required Reporting-MTA Address", (Throwable)e);
        }
    }

    private void appendRecipient(StringBuffer buffer, MailAddress mailAddress, String deliveryError, Date lastUpdated) {
        buffer.append(LINE_BREAK);
        buffer.append("Final-Recipient: rfc822; " + mailAddress.toString()).append(LINE_BREAK);
        buffer.append("Action: failed").append(LINE_BREAK);
        buffer.append("Status: " + deliveryError).append(LINE_BREAK);
        buffer.append("Diagnostic-Code: " + this.getDiagnosticType(deliveryError) + "; " + deliveryError).append(LINE_BREAK);
        buffer.append("Last-Attempt-Date: " + this.dateFormatter.format(lastUpdated)).append(LINE_BREAK);
    }

    private String getDeliveryError(Mail originalMail) {
        String deliveryError = (String)((Object)originalMail.getAttribute("delivery-error"));
        if (deliveryError != null) {
            return deliveryError;
        }
        return "unknown";
    }

    private String getDiagnosticType(String diagnosticCode) {
        if (DIAG_PATTERN.matcher(diagnosticCode).matches()) {
            return "smtp";
        }
        return "X-James";
    }

    private MimeBodyPart createAttachedOriginal(Mail originalMail, TypeCode attachmentType) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        MimeMessage originalMessage = originalMail.getMessage();
        if (attachmentType.equals((Object)TypeCode.HEADS)) {
            part.setContent((Object)new MimeMessageUtils(originalMessage).getMessageHeaders(), "text/plain");
            part.setHeader("Content-Type", "text/rfc822-headers");
        } else {
            part.setContent((Object)originalMessage, "message/rfc822");
        }
        if (originalMessage.getSubject() != null && originalMessage.getSubject().trim().length() > 0) {
            part.setFileName(originalMessage.getSubject().trim());
        } else {
            part.setFileName("No Subject");
        }
        part.setDisposition("Attachment");
        return part;
    }

    @Override
    public MimeMessageModifier getMimeMessageModifier(Mail newMail, Mail originalMail) throws MessagingException {
        return new MimeMessageModifier(originalMail.getMessage());
    }
}

