/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.james.mailbox.model.MailboxId;

public class MessageMoves {
    private final ImmutableSet<MailboxId> previousMailboxIds;
    private final ImmutableSet<MailboxId> targetMailboxIds;

    public static Builder builder() {
        return new Builder();
    }

    private MessageMoves(Collection<MailboxId> previousMailboxIds, Collection<MailboxId> targetMailboxIds) {
        this.previousMailboxIds = ImmutableSet.copyOf(previousMailboxIds);
        this.targetMailboxIds = ImmutableSet.copyOf(targetMailboxIds);
    }

    public boolean isChange() {
        return !this.previousMailboxIds.equals(this.targetMailboxIds);
    }

    public Set<MailboxId> addedMailboxIds() {
        return Sets.difference(this.targetMailboxIds, this.previousMailboxIds);
    }

    public Set<MailboxId> removedMailboxIds() {
        return Sets.difference(this.previousMailboxIds, this.targetMailboxIds);
    }

    public static class Builder {
        private final ImmutableSet.Builder<MailboxId> previousMailboxIds = ImmutableSet.builder();
        private final ImmutableSet.Builder<MailboxId> targetMailboxIds = ImmutableSet.builder();

        private Builder() {
        }

        public Builder previousMailboxIds(Collection<MailboxId> mailboxIds) {
            this.previousMailboxIds.addAll(mailboxIds);
            return this;
        }

        public Builder previousMailboxIds(MailboxId ... mailboxIds) {
            this.previousMailboxIds.addAll(Arrays.asList(mailboxIds));
            return this;
        }

        public Builder targetMailboxIds(Collection<MailboxId> mailboxIds) {
            this.targetMailboxIds.addAll(mailboxIds);
            return this;
        }

        public Builder targetMailboxIds(MailboxId ... mailboxIds) {
            this.targetMailboxIds.addAll(Arrays.asList(mailboxIds));
            return this;
        }

        public MessageMoves build() {
            return new MessageMoves((Collection)this.previousMailboxIds.build(), (Collection)this.targetMailboxIds.build());
        }
    }
}

