/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.UpdatedFlags;

public interface MailboxListener {
    public ListenerType getType();

    default public ExecutionMode getExecutionMode() {
        return ExecutionMode.SYNCHRONOUS;
    }

    public void event(Event var1);

    public static abstract class Added
    extends MetaDataHoldingEvent {
        private static final long serialVersionUID = 1L;

        public Added(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        @Override
        public abstract MessageMetaData getMetaData(MessageUid var1);
    }

    public static abstract class FlagsUpdated
    extends MessageEvent {
        private static final long serialVersionUID = 1L;

        public FlagsUpdated(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract List<UpdatedFlags> getUpdatedFlags();
    }

    public static abstract class Expunged
    extends MetaDataHoldingEvent {
        private static final long serialVersionUID = 1L;

        public Expunged(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        @Override
        public abstract MessageMetaData getMetaData(MessageUid var1);
    }

    public static abstract class MetaDataHoldingEvent
    extends MessageEvent {
        public MetaDataHoldingEvent(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract MessageMetaData getMetaData(MessageUid var1);
    }

    public static abstract class MessageEvent
    extends MailboxEvent {
        private static final long serialVersionUID = 1L;

        public MessageEvent(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract List<MessageUid> getUids();
    }

    public static class MailboxACLUpdated
    extends MailboxEvent {
        private final ACLDiff aclDiff;
        private static final long serialVersionUID = 1L;

        public MailboxACLUpdated(MailboxSession session, MailboxPath path, ACLDiff aclDiff) {
            super(session, path);
            this.aclDiff = aclDiff;
        }

        public ACLDiff getAclDiff() {
            return this.aclDiff;
        }
    }

    public static abstract class MailboxRenamed
    extends MailboxEvent {
        private static final long serialVersionUID = 1L;

        public MailboxRenamed(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract MailboxPath getNewPath();
    }

    public static class MailboxAdded
    extends MailboxEvent {
        private static final long serialVersionUID = 1L;

        public MailboxAdded(MailboxSession session, MailboxPath path) {
            super(session, path);
        }
    }

    public static class MailboxDeletion
    extends MailboxEvent {
        private static final long serialVersionUID = 1L;

        public MailboxDeletion(MailboxSession session, MailboxPath path) {
            super(session, path);
        }
    }

    public static abstract class MailboxEvent
    implements Event,
    Serializable {
        private final MailboxSession session;
        private final MailboxPath path;

        public MailboxEvent(MailboxSession session, MailboxPath path) {
            this.session = session;
            this.path = path;
        }

        @Override
        public MailboxSession getSession() {
            return this.session;
        }

        public MailboxPath getMailboxPath() {
            return this.path;
        }
    }

    public static class QuotaUsageUpdatedEvent
    implements QuotaEvent,
    Serializable {
        private final MailboxSession session;
        private final QuotaRoot quotaRoot;
        private final Quota<QuotaCount> countQuota;
        private final Quota<QuotaSize> sizeQuota;
        private final Instant instant;

        public QuotaUsageUpdatedEvent(MailboxSession session, QuotaRoot quotaRoot, Quota<QuotaCount> countQuota, Quota<QuotaSize> sizeQuota, Instant instant) {
            this.session = session;
            this.quotaRoot = quotaRoot;
            this.countQuota = countQuota;
            this.sizeQuota = sizeQuota;
            this.instant = instant;
        }

        @Override
        public MailboxSession getSession() {
            return this.session;
        }

        public Quota<QuotaCount> getCountQuota() {
            return this.countQuota;
        }

        public Quota<QuotaSize> getSizeQuota() {
            return this.sizeQuota;
        }

        @Override
        public QuotaRoot getQuotaRoot() {
            return this.quotaRoot;
        }

        public Instant getInstant() {
            return this.instant;
        }

        public final boolean equals(Object o) {
            if (o instanceof QuotaUsageUpdatedEvent) {
                QuotaUsageUpdatedEvent that = (QuotaUsageUpdatedEvent)o;
                return Objects.equals(this.session, that.session) && Objects.equals(this.quotaRoot, that.quotaRoot) && Objects.equals(this.countQuota, that.countQuota) && Objects.equals(this.sizeQuota, that.sizeQuota) && Objects.equals(this.instant, that.instant);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.session, this.quotaRoot, this.countQuota, this.sizeQuota, this.instant);
        }
    }

    public static interface QuotaEvent
    extends Event {
        public QuotaRoot getQuotaRoot();
    }

    public static enum ExecutionMode {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }

    public static enum ListenerType {
        ONCE,
        EACH_NODE,
        MAILBOX;

    }
}

